package com.digiwin.mobile.mobileuibot.core.component.input.scan;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjj
 * @date 2021/12/14 0014 16:16
 */
public class InputScanMultiAnalyzer implements ComponentParamAnalyzer<InputScanMulti, List<String>> {
    Logger logger = LoggerFactory.getLogger(InputScanMultiAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputScanMulti.COMPONENT_TYPE;
    }

    @Override
    public Class<InputScanMulti> getSubmitParamType() {
        return InputScanMulti.class;
    }

    @Override
    public List<String> analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputScanMulti)) {
            logger.debug("submitParam is not instanceof InputScanMulti component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return new ArrayList<>();
        }
        InputScanMulti inputScanMulti = (InputScanMulti) submitParam;
        return inputScanMulti.getQrCodeResults();
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
