package com.digiwin.mobile.mobileuibot.core.component.input.scan;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author zhangjj
 * @date 2021/12/14 0014 16:16
 */
public class InputScanSingleAnalyzer implements ComponentParamAnalyzer<InputScanSingle, String> {
    Logger logger = LoggerFactory.getLogger(InputScanSingleAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputScanSingle.COMPONENT_TYPE;
    }

    @Override
    public Class<InputScanSingle> getSubmitParamType() {
        return InputScanSingle.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputScanSingle)) {
            logger.debug("submitParam is not instanceof InputScanSingle component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputScanSingle inputScanSingle = (InputScanSingle) submitParam;
        return inputScanSingle.getQrCodeResult();
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
