package com.digiwin.mobile.mobileuibot.core.component.input.scan.standard;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：标准扫码组件组件 -- V2版新增</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputScan.java
 * @Author: wangjwc
 * @Date: created at 2024/3/18 16:33
 */
@Data
public class InputScan extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 6835905431866833719L;
    public static final String COMPONENT_TYPE = "INPUT_SCAN";

    private String title;
    // 录入内容
    private String text;
    /**
     * 扫码栏位类型
     *
     * @see InputScanTypeEnum
     */
    private Integer scanType = InputScanTypeEnum.SINGLE_TEXT_SCAN.getValue();

    /**
     * 设计器配置(透传Js给前端处理)
     */
    private String actionJsEvent;

    @Override
    public String returnComponentType() {
        return InputScan.COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema))
                .map(Object::toString)
                .orElse(null);
        if (StringUtils.hasLength(value)) {
            this.text = value;
        } else {
            if (BooleanUtils.isTrue(this.enable)) {
                // 输入型，暂定无默认值
            } else {
                this.text = "";
            }
        }
    }
}