package com.digiwin.mobile.mobileuibot.core.component.input.scan.standard;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Optional;

/**
 * <p>功能描述：标准扫码组件组件 提交参数解析</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputScanParamAnalyzer.java
 * @Author: wangjwc
 * @Date: created at 2024/3/18 17:23
 */
@Slf4j
@Component("inputScanParamAnalyzer")
public class InputScanParamAnalyzer implements ComponentParamAnalyzer<InputScan, Object> {

    @Override
    public String getComponentType() {
        return InputScan.COMPONENT_TYPE;
    }

    @Override
    public Class<InputScan> getSubmitParamType() {
        return InputScan.class;
    }

    @Override
    public Object analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputScan)) {
            log.debug("submitParam is not instanceof InputScan component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return null;
        }
        Object value = null;
        InputScan inputScan = (InputScan) submitParam;
        Integer scanType = inputScan.getScanType();
        String text = inputScan.getText();
        if (InputScanTypeEnum.SINGLE_TEXT_SCAN.getValue().equals(scanType)) {
            value = Optional.ofNullable(text).orElse("");
        } else if (InputScanTypeEnum.MULTI_TEXT_SCAN.getValue().equals(scanType)) {
            value = Optional.ofNullable(text).orElse("");
        } else if (InputScanTypeEnum.NUMERIC_SCAN.getValue().equals(scanType)) {
            if (StringUtils.hasLength(text)) {
                if (text.contains(".")) {
                    value = Double.parseDouble(text);
                } else {
                    value = Integer.parseInt(text);
                }
            }
        }
        return value;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
    }
}