package com.digiwin.mobile.mobileuibot.core.component.input.sign;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：签名组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputSign
 * @Author: Zaregoto
 * @Date: 2021/9/5 23:27
 */
@Data
public class InputSign extends BaseInputMobileComponent {
    private static final long serialVersionUID = 8325862362775443259L;
    public static final String COMPONENT_TYPE = "INPUT_SIGN";

    @Override
    public String returnComponentType() {
        return InputSign.COMPONENT_TYPE;
    }

    private String title;
    private String editPlaceholder;
    private Boolean timestampAppend = true;
    private String timestampFormat = "YYYY.MM.DD HH:MM:SS";
    // 提交数据
    private String signData;
    //支持大小图模式 0:大图,1:小图,默认大图
    private Integer displayStyle = 0;
    //提交的点位信息
    private String points ;
    //点位的schema
    private String pointSchema;
    //点位的schemaPath
    private String pointSchemaPath;

    public static InputSign create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList,
                                   Map<String, Object> bizData, List<Rule> mobileRuleList) {
        InputSign inputSign = new InputSign();
        inputSign.setTitle(column.getHeaderName());
        inputSign.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "点此区域签名"));
        inputSign.setEditPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请在空白区域签名"));
        inputSign.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请完成"),
                column.getHeaderName(),
                "")
        );
//        inputSign.setTimestampAppend(true);
//        inputSign.setTimestampFormat("YYYY.MM.DD HH:MM:SS");
        Optional<Rule> optRequiredRule = mobileRuleList.stream()
                .filter(r ->
                        RuleCategoryEnum.VALIDATE.getCategory().equalsIgnoreCase(r.getCategory())
                                && ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(r.getType())
                ).findFirst();
        if (optRequiredRule.isPresent()) {
            inputSign.setRequired(true);
        } else {
            inputSign.setRequired(false);
        }
        inputSign.setSignData(String.valueOf(bizData.get(column.getSchema())));

        return inputSign;
    }

    public static InputSign create(String locale, String title, String schema,
                                   Map<String, Object> bizData, List<Rule> mobileRuleList) {
        InputSign inputSign = new InputSign();
        inputSign.setTitle(title);
        inputSign.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "点此区域签名"));
        inputSign.setEditPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请在空白区域签名"));
        inputSign.setErrorMessage(LocaleUtil.getPhrasedMobileText(
                locale,
                LocaleUtil.getMobileTextByKey(locale, "请完成"),
                title,
                "")
        );
        //        inputSign.setTimestampAppend(true);
        //        inputSign.setTimestampFormat("YYYY.MM.DD HH:MM:SS");
        Optional<Rule> optRequiredRule = mobileRuleList.stream()
                .filter(r ->
                        RuleCategoryEnum.VALIDATE.getCategory().equalsIgnoreCase(r.getCategory())
                                && ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(r.getType())
                ).findFirst();
        if (optRequiredRule.isPresent()) {
            inputSign.setRequired(true);
        } else {
            inputSign.setRequired(false);
        }
        inputSign.setSignData(String.valueOf(bizData.get(schema)));

        return inputSign;
    }

    public static InputSign createEmpty() {
        return new InputSign();
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema))
                .map(Object::toString)
                .orElse(null);
        if (StringUtils.hasLength(value)) {
            this.signData = value;
        }
        //获取点位的信息
        String pointValue = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, this.pointSchemaPath, this.pointSchema))
                .map(Object::toString)
                .orElse(null);
        if (StringUtils.hasLength(pointValue)) {
            this.points = pointValue;
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputSign inputSign = new InputSign();
        inputSign.setComponentId(rawContent.getComponentId());
        inputSign.setTitle(rawContent.getLabel());
        inputSign.setEnable(rawContent.getEditable());
        //将配置中的setting转化成成对象
        Card.DesignerRawCard.Content.InputSignObj inputSignObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.InputSignObj.class);
        if (inputSignObj != null) {
            inputSign.setEditPlaceholder(inputSignObj.getEditPlaceholder());
            inputSign.setPlaceholder(inputSignObj.getPlaceholder());
            inputSign.setDisplayStyle(inputSignObj.getDisplayStyle());
            inputSign.setTimestampAppend(inputSignObj.getTimestampAppend());
            inputSign.setPointSchemaPath(inputSignObj.getPointSchemaPath());
            inputSign.setPointSchema(inputSignObj.getPointSchema());
        }
        inputSign.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputSign;
    }
}
