package com.digiwin.mobile.mobileuibot.core.component.input.sign;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputSignParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/9/5 23:32
 */
@Component
public class InputSignParamAnalyzer implements ComponentParamAnalyzer<InputSign, String> {

    private static final Logger logger = LoggerFactory.getLogger(InputSignParamAnalyzer.class);

    @Override public String getComponentType() {
        return InputSign.COMPONENT_TYPE;
    }

    @Override public Class<InputSign> getSubmitParamType() {
        return InputSign.class;
    }

    @Override public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputSign)) {
            logger.debug("submitParam is not instanceof InputSign component..."
                + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputSign inputSign = (InputSign) submitParam;
        return Optional.ofNullable(inputSign.getSignData()).orElse("");
    }

    @Override public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
        UiBotPageData pageData, Object... args) {

    }
}
