package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotFieldOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 按钮单选组件
 *
 * @author zhangjj
 * @date 2022/3/18 4:15 PM
 */
@Slf4j
@Data
public class ButtonSingleSelect extends InputSingleSelect implements Serializable {
    private static final long serialVersionUID = -9136892746109988043L;
    public static final String COMPONENT_TYPE = "BUTTON_SINGLE_SELECT";

    /**
     * 选中的id
     */
    private List<String> selectIdList = new ArrayList<>();

    public static ButtonSingleSelect createByTbds(UiBotLayout layout, LocaleService localeService, String locale, Object value) {
        ButtonSingleSelect buttonSingleSelect = new ButtonSingleSelect();
        buttonSingleSelect.setTitle(localeService.getLanguageValue(locale, layout.getLabel()));
        buttonSingleSelect.setRequired(true);
        List<InputSingleSelectOption> optionList = new ArrayList<>(2);
        if (!StringUtils.hasLength((String) value)) {
            value = "Y";
        }
        optionList.add(InputSingleSelectOption.create(ModuleUtils.YES, localeService.getLanguageValue(locale, "通过"), ModuleUtils.YES.equals(value)));
        optionList.add(InputSingleSelectOption.create(ModuleUtils.NO, localeService.getLanguageValue(locale, "不通过"), ModuleUtils.NO.equals(value)));
        buttonSingleSelect.setOptionList(optionList);
        return buttonSingleSelect;
    }

    @Override
    public String returnComponentType() {
        return ButtonSingleSelect.COMPONENT_TYPE;
    }

    public static ButtonSingleSelect create(UiBotLayout uiBotFieldLayout, List<UiBotRule> uiBotRuleList) {
        ButtonSingleSelect buttonSingleSelect = new ButtonSingleSelect();
        buttonSingleSelect.setTitle(uiBotFieldLayout.getHeaderName());
        List<InputSingleSelectOption> optionList = new ArrayList<>();
        List<UiBotFieldOption> uiBotFieldOptionList = uiBotFieldLayout.getOptions();
        if (uiBotFieldOptionList != null && !uiBotFieldOptionList.isEmpty()) {
            for (UiBotFieldOption uiBotFieldOption : uiBotFieldOptionList) {
                InputSingleSelectOption option = new InputSingleSelectOption();
                option.setId(uiBotFieldOption.getValue().toString());
                option.setName(uiBotFieldOption.getTitle());
                optionList.add(option);
            }
        }
        buttonSingleSelect.setSchema(uiBotFieldLayout.getSchema());
        //必填设置
        Optional<UiBotRule> uiBotRuleOptional = uiBotRuleList.stream().filter(uiBotRule ->
                uiBotFieldLayout.getSchema().equalsIgnoreCase(uiBotRule.getSchema())
                        && "required".equalsIgnoreCase(uiBotRule.getKey())
        ).findFirst();
        buttonSingleSelect.setRequired(uiBotRuleOptional.isPresent());
        buttonSingleSelect.setOptionList(optionList);
        return buttonSingleSelect;
    }

    public static ButtonSingleSelect create(UiBotLayout uiBotLayout, Map<String, Object> data, String pageId, String locale, Boolean isComplete) {
        if ("executeState".equals(uiBotLayout.getSchema())) {
            ButtonSingleSelect buttonSingleSelect = new ButtonSingleSelect();
            buttonSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
            /**
             * 这里属于纯定制接口参数
             */
            List<InputSingleSelectOption> optionList = new ArrayList<>(2);
            InputSingleSelectOption option1 = new InputSingleSelectOption();
            RelationRule relationRule = new RelationRule();
            List<CommonRule> ruleList = relationRule.getRuleList();
            //选择已执行时，需要展示实际开始、结束、小时、分钟
            CommonRule commonRule = new CommonRule();
            commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule.setTargetSchema("actualStartTime");
            commonRule.setTargetText(DateTimeUtil.getTodayTimeUseDefaultPattern());
            commonRule.setTargetHidden(false);
            commonRule.setTargetEnable(!isComplete);
            CommonRule commonRule1 = new CommonRule();
            commonRule1.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule1.setTargetSchema("actualEndTime");
            commonRule1.setTargetText(DateTimeUtil.getTodayTimeUseDefaultPattern());
            commonRule1.setTargetHidden(false);
            commonRule1.setTargetEnable(!isComplete);
            CommonRule commonRule2 = new CommonRule();
            commonRule2.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule2.setTargetSchema("actualHours");
            commonRule2.setTargetEnable(!isComplete);
            commonRule2.setTargetText("0");
            commonRule2.setTargetHidden(false);
            CommonRule commonRule3 = new CommonRule();
            commonRule3.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule3.setTargetSchema("actualMinutes");
            commonRule3.setTargetEnable(!isComplete);
            commonRule3.setTargetText("0");
            commonRule3.setTargetHidden(false);
            ruleList.add(commonRule);
            ruleList.add(commonRule1);
            ruleList.add(commonRule2);
            ruleList.add(commonRule3);

            option1.setRelationRule(relationRule);
            option1.setId("1");
            option1.setName(LocaleUtil.getMobileTextByKey(locale, "已执行"));
            option1.setSelected(true);
            optionList.add(option1);

            InputSingleSelectOption option2 = new InputSingleSelectOption();
            RelationRule relationRule1 = new RelationRule();
            List<CommonRule> ruleList1 = relationRule1.getRuleList();
            //选择未执行时，需要隐藏实际开始、结束、小时、分钟
            CommonRule commonRule4 = new CommonRule();
            commonRule4.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule4.setTargetSchema("actualStartTime");
            commonRule4.setTargetText(DateTimeUtil.getTodayTimeUseDefaultPattern());
            commonRule4.setTargetHidden(true);
            CommonRule commonRule5 = new CommonRule();
            commonRule5.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule5.setTargetSchema("actualEndTime");
            commonRule5.setTargetText(DateTimeUtil.getTodayTimeUseDefaultPattern());
            commonRule5.setTargetHidden(true);
            CommonRule commonRule6 = new CommonRule();
            commonRule6.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule6.setTargetSchema("actualHours");
            commonRule6.setTargetText("1");
            commonRule6.setTargetHidden(true);
            CommonRule commonRule7 = new CommonRule();
            commonRule7.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule7.setTargetSchema("actualMinutes");
            commonRule7.setTargetText("1");
            commonRule7.setTargetHidden(true);
            ruleList1.add(commonRule4);
            ruleList1.add(commonRule5);
            ruleList1.add(commonRule6);
            ruleList1.add(commonRule7);

            option2.setRelationRule(relationRule1);
            option2.setId("0");
            option2.setName(LocaleUtil.getMobileTextByKey(locale, "未执行"));
            option2.setSelected(false);
            optionList.add(option2);

            buttonSingleSelect.setSchema(uiBotLayout.getSchema());
            //必填设置
            buttonSingleSelect.setRequired(true);
            buttonSingleSelect.setOptionList(optionList);
            buttonSingleSelect.setEnable(!isComplete);
            return buttonSingleSelect;
        }
        return new ButtonSingleSelect();
    }


    public static ButtonSingleSelect createByZtbShiftingAbnormalAlarm(UiBotLayout uiBotLayout, String locale, Boolean isComplete) {
        if ("shifting_reason".equals(uiBotLayout.getSchema())) {
            ButtonSingleSelect buttonSingleSelect = new ButtonSingleSelect();
            buttonSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
            /**
             * 这里属于纯定制接口参数
             */
            List<InputSingleSelectOption> optionList = new ArrayList<>(3);
            InputSingleSelectOption option1 = new InputSingleSelectOption();
            RelationRule relationRule1 = new RelationRule();
            List<CommonRule> ruleList1 = relationRule1.getRuleList();
            //选择中途转运，需要展示司机名称,司机手机号,其他 隐藏备注
            CommonRule commonRule = new CommonRule();
            commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule.setTargetSchema("driverName");
            commonRule.setTargetText("");
            commonRule.setTargetHidden(false);
            commonRule.setTargetRequired(true);
            commonRule.setTargetEnable(!isComplete);
            CommonRule commonRule1 = new CommonRule();
            commonRule1.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule1.setTargetSchema("driverPhone");
            commonRule1.setTargetText("");
            commonRule1.setTargetHidden(false);
            commonRule1.setTargetRequired(true);
            commonRule1.setTargetEnable(!isComplete);
            CommonRule commonRule2 = new CommonRule();
            commonRule2.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule2.setTargetSchema("licensePlateNo");
            commonRule2.setTargetEnable(!isComplete);
            commonRule2.setTargetText("");
            commonRule2.setTargetHidden(false);
            commonRule2.setTargetRequired(true);
            CommonRule commonRule3 = new CommonRule();
            commonRule3.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule3.setTargetSchema("remark");
            commonRule3.setTargetEnable(!isComplete);
            commonRule3.setTargetText("");
            commonRule3.setTargetHidden(true);
            commonRule3.setTargetRequired(false);
            ruleList1.add(commonRule);
            ruleList1.add(commonRule1);
            ruleList1.add(commonRule2);
            ruleList1.add(commonRule3);

            option1.setRelationRule(relationRule1);
            option1.setId("0");
            option1.setName(LocaleUtil.getMobileTextByKey(locale, "中途转运"));
            option1.setSelected(true);
            optionList.add(option1);

            InputSingleSelectOption option2 = new InputSingleSelectOption();
            RelationRule relationRule2 = new RelationRule();
            List<CommonRule> ruleList2 = relationRule2.getRuleList();
            //选择中途提货，需要隐藏司机名称,司机手机号,其他,备注
            CommonRule commonRule4 = new CommonRule();
            commonRule4.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule4.setTargetSchema("driverName");
            commonRule4.setTargetText("");
            commonRule4.setTargetHidden(true);
            commonRule4.setTargetRequired(false);
            CommonRule commonRule5 = new CommonRule();
            commonRule5.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule5.setTargetSchema("driverPhone");
            commonRule5.setTargetText("");
            commonRule5.setTargetHidden(true);
            commonRule5.setTargetRequired(false);
            CommonRule commonRule6 = new CommonRule();
            commonRule6.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule6.setTargetSchema("licensePlateNo");
            commonRule6.setTargetText("");
            commonRule6.setTargetHidden(true);
            commonRule6.setTargetRequired(false);
            CommonRule commonRule7 = new CommonRule();
            commonRule7.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule7.setTargetSchema("remark");
            commonRule7.setTargetText("");
            commonRule7.setTargetHidden(true);
            commonRule7.setTargetRequired(false);
            ruleList2.add(commonRule4);
            ruleList2.add(commonRule5);
            ruleList2.add(commonRule6);
            ruleList2.add(commonRule7);

            option2.setRelationRule(relationRule2);
            option2.setId("1");
            option2.setName(LocaleUtil.getMobileTextByKey(locale, "中途提货"));
            option2.setSelected(false);
            optionList.add(option2);


            InputSingleSelectOption option3 = new InputSingleSelectOption();
            RelationRule relationRule3 = new RelationRule();
            List<CommonRule> ruleList3 = relationRule3.getRuleList();
            //选择中途提货，需要隐藏司机名称,司机手机号,其他,显示备注
            CommonRule commonRule8 = new CommonRule();
            commonRule8.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule8.setTargetSchema("driverName");
            commonRule8.setTargetText("");
            commonRule8.setTargetHidden(true);
            commonRule8.setTargetRequired(false);
            CommonRule commonRule9 = new CommonRule();
            commonRule9.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule9.setTargetSchema("driverPhone");
            commonRule9.setTargetText("");
            commonRule9.setTargetHidden(true);
            commonRule9.setTargetRequired(false);
            CommonRule commonRule10 = new CommonRule();
            commonRule10.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule10.setTargetSchema("licensePlateNo");
            commonRule10.setTargetText("");
            commonRule10.setTargetHidden(true);
            commonRule10.setTargetRequired(false);
            CommonRule commonRule11 = new CommonRule();
            commonRule11.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule11.setTargetSchema("remark");
            commonRule11.setTargetText("");
            commonRule11.setTargetHidden(false);
            commonRule11.setTargetRequired(true);
            ruleList3.add(commonRule8);
            ruleList3.add(commonRule9);
            ruleList3.add(commonRule10);
            ruleList3.add(commonRule11);

            option3.setRelationRule(relationRule3);
            option3.setId("2");
            option3.setName(LocaleUtil.getMobileTextByKey(locale, "其他"));
            option3.setSelected(false);
            optionList.add(option3);

            buttonSingleSelect.setSchema(uiBotLayout.getSchema());
            //必填设置
            buttonSingleSelect.setRequired(true);
            buttonSingleSelect.setOptionList(optionList);
            buttonSingleSelect.setEnable(!isComplete);
            return buttonSingleSelect;
        }
        return new ButtonSingleSelect();
    }

    public static ButtonSingleSelect createByZtbStopAbnormalAlarm(UiBotLayout uiBotLayout, String locale,
                                                                  Boolean isComplete, Map<String, Object> data,
                                                                  DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        if ("stop_reason".equals(uiBotLayout.getSchema())) {
            ButtonSingleSelect buttonSingleSelect = new ButtonSingleSelect();
            buttonSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
            /**
             * 这里属于纯定制接口参数
             */
            List<InputSingleSelectOption> optionList = new ArrayList<>(3);
            InputSingleSelectOption option1 = new InputSingleSelectOption();
            RelationRule relationRule1 = new RelationRule();
            List<CommonRule> ruleList1 = relationRule1.getRuleList();
            //选择中途转运，需要展示司机名称,司机手机号,其他 隐藏备注
            CommonRule commonRule1 = new CommonRule();
            commonRule1.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule1.setTargetSchema("remark");
            commonRule1.setTargetEnable(!isComplete);
            commonRule1.setTargetText("");
            commonRule1.setTargetHidden(true);
            commonRule1.setTargetRequired(false);
            ruleList1.add(commonRule1);
            option1.setRelationRule(relationRule1);
            option1.setId("0");
            option1.setName(LocaleUtil.getMobileTextByKey(locale, "休息"));
            option1.setSelected(true);
            optionList.add(option1);

            InputSingleSelectOption option2 = new InputSingleSelectOption();
            RelationRule relationRule2 = new RelationRule();
            List<CommonRule> ruleList2 = relationRule2.getRuleList();
            //选择中途提货，需要隐藏司机名称,司机手机号,其他,备注
            CommonRule commonRule2 = new CommonRule();
            commonRule2.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule2.setTargetSchema("remark");
            commonRule2.setTargetText("");
            commonRule2.setTargetHidden(true);
            commonRule2.setTargetRequired(false);
            ruleList2.add(commonRule2);
            option2.setRelationRule(relationRule2);
            option2.setId("1");
            option2.setName(LocaleUtil.getMobileTextByKey(locale, "车辆维修"));
            option2.setSelected(false);
            optionList.add(option2);

            InputSingleSelectOption option3 = new InputSingleSelectOption();
            RelationRule relationRule3 = new RelationRule();
            List<CommonRule> ruleList3 = relationRule3.getRuleList();
            //选择中途提货，需要隐藏司机名称,司机手机号,其他,显示备注
            CommonRule commonRule3 = new CommonRule();
            commonRule3.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule3.setTargetSchema("remark");
            commonRule3.setTargetText("");
            commonRule3.setTargetHidden(false);
            commonRule3.setTargetRequired(true);
            ruleList3.add(commonRule3);
            option3.setRelationRule(relationRule3);
            option3.setId("2");
            option3.setName(LocaleUtil.getMobileTextByKey(locale, "其他"));
            option3.setSelected(false);
            optionList.add(option3);

            InputSingleSelectOption option4 = new InputSingleSelectOption();
            RelationRule relationRule4 = new RelationRule();
            List<CommonRule> ruleList4 = relationRule4.getRuleList();
            //选择中途提货，需要隐藏司机名称,司机手机号,其他,显示备注
            CommonRule commonRule4 = new CommonRule();
            commonRule4.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            commonRule4.setTargetSchema("remark");
            commonRule4.setTargetText("");
            commonRule4.setTargetHidden(true);
            commonRule4.setTargetRequired(false);
            ruleList4.add(commonRule4);
            option4.setRelationRule(relationRule4);
            option4.setId("3");
            option4.setName(LocaleUtil.getMobileTextByKey(locale, "中途转运"));
            option4.setSelected(false);
            Action action = new Action();
            action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
            Map<String, Object> buttonRawData = new HashMap<>();
            buttonRawData.put("page_id", "MOBILE_ZTB_TRANSPORT_VEHICLE_INFO");
            buttonRawData.put("action_id", "transfer");
            buttonRawData.put("jumpPageTitle", "转运司机");
            buttonRawData.put("transport_no", data.get("transport_no"));
            buttonRawData.put("task_no", data.get("task_no"));
            buttonRawData.put("action", data.get("action"));
            buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());

            buttonRawData.put("data", data);
            //rawData里存提交接口所需参数
            action.setRawData(buttonRawData);
            log.debug("action:" + JSONUtil.toJsonStr(action));
            option4.setAction(action);
            optionList.add(option4);

            buttonSingleSelect.setSchema(uiBotLayout.getSchema());
            //必填设置
            buttonSingleSelect.setRequired(true);
            buttonSingleSelect.setOptionList(optionList);
            buttonSingleSelect.setEnable(!isComplete);
            return buttonSingleSelect;
        }
        return new ButtonSingleSelect();
    }

    private static UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List<UiBotLayout> layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty(layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<>();
        outer:
        for (UiBotLayout layout : layoutList) {
            List<UiBotAction> actions = layout.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                continue;
            }
            for (UiBotAction action : actions) {
                if (actionId.equalsIgnoreCase(action.getActionId())) {
                    uiBotAction.set(action);
                    break outer;
                }
            }
        }
        return uiBotAction.get();
    }


    /**
     * 设置第一个可选项选中
     */
    public void setFirstDefaultOption() {
        List<InputSingleSelectOption> optionList = this.getOptionList();
        if (optionList == null || optionList.isEmpty()) {
            return;
        }
        for (int i = 0; i < optionList.size(); i++) {
            if (i == 0) {
                optionList.get(i).setSelected(true);
            } else {
                optionList.get(i).setSelected(false);
            }
        }
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Object value = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (value != null) {
            if (value instanceof List) {
                List<String> valueList = (List<String>) value;
                if (!CollectionUtils.isEmpty(valueList)) {
                    if (valueList.size() == 1) {
                        // 单选
                        this.setSelectId(valueList.get(0));
                    }
                    this.selectIdList = valueList;
                    //初始化optionList
                    this.selectIdList.stream()
                            .filter(StringUtil::isNotEmpty)
                            .forEach(selected -> this.getOptionList().stream()
                                    .filter(option -> option.getId().equals(selected))
                                    .forEach(option -> option.setSelected(true)));
                }
            } else {
                // 防呆，如：之前PCM项目预算签核任务卡筛选功能存储的是字符串
                this.setSelectId(StringUtil.valueOf(value));
                //初始化optionList
                this.getOptionList().stream()
                        .filter(option -> option.getId().equals(StringUtil.valueOf(value)))
                        .forEach(option -> option.setSelected(true));
            }
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        ButtonSingleSelect buttonSingleSelect = new ButtonSingleSelect();
        buttonSingleSelect.setComponentId(rawContent.getComponentId());
        buttonSingleSelect.setTitle(rawContent.getLabel());
        buttonSingleSelect.setEnable(rawContent.getEditable());
        //将配置中的setting转化成成对象
        Card.DesignerRawCard.Content.ButtonSingleSelectObj buttonSingleSelectObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.ButtonSingleSelectObj.class);
        if (buttonSingleSelectObj != null) {
            buttonSingleSelect.setOptionList(buttonSingleSelectObj.getOptionList());
            buttonSingleSelect.setShowType(buttonSingleSelectObj.getShowType());
            buttonSingleSelect.setType(buttonSingleSelectObj.getShowType());
            buttonSingleSelect.setStyleType(buttonSingleSelectObj.getStyleType());
        }
        buttonSingleSelect.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return buttonSingleSelect;
    }
}