package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zhangjj
 * @date 2022/3/24 4:37 PM
 */
@Component
@Slf4j
public class ButtonSingleSelectParamAnalyzer implements ComponentParamAnalyzer<ButtonSingleSelect, Object> {
    @Override
    public String getComponentType() {
        return ButtonSingleSelect.COMPONENT_TYPE;
    }

    @Override
    public Class<ButtonSingleSelect> getSubmitParamType() {
        return ButtonSingleSelect.class;
    }

    @Override
    public Object analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof ButtonSingleSelect)) {
            log.debug("submitParam is not instanceof ButtonSingleSelect component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        ButtonSingleSelect buttonSingleSelect = (ButtonSingleSelect) submitParam;
        if (SingleSelectTypeEnum.MULTI_SELECT.getValue().equals(buttonSingleSelect.getType())) {
            return buttonSingleSelect.getSelectIdList();
        } else {
            if (CollectionUtils.isEmpty(buttonSingleSelect.getSelectIdList())) {
                return Optional.ofNullable(buttonSingleSelect.getSelectId()).orElse("");
            } else {
                return buttonSingleSelect.getSelectIdList().get(0);
            }
        }
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
        Map<String, Object> displayParam = (Map<String, Object>) pageData.get(pageDataKey);
        List<Map<String, Object>> optionList = (List<Map<String, Object>>) displayParam.get("optionList");
        if (optionList != null && !optionList.isEmpty()) {
            for (Map<String, Object> option : optionList) {
                option.put("name", LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), (String) option.get("name")));
            }
        }
    }
}