package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCalendar;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 弹窗单选分组组件
 *
 * @author wuyangz
 * @date 2022/5/11
 */
@Data
public class InputGroupSingleSelect extends BaseInputMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "GROUP_SINGLE_SELECT";
    private static final long serialVersionUID = -4324314400271154303L;

    /**
     * 组件标题
     */
    private String title;
    /**
     * 分组选项
     */
    private List<InputGroupSingleSelectOption> groupList;
    /**
     * 分组数量
     */
    private int groupNums;
    /**
     * 分组开窗的标题
     */
    private String groupTitle;
    /**
     * 方便前端拿取默认值
     */
    private String text;

    public static InputGroupSingleSelect create(UiBotLayout uiBotLayout, List<DigiwinAtmcCalendar> digiwinAtmcCalendars, String locale) {
        InputGroupSingleSelect inputSingleSelect = new InputGroupSingleSelect();
        inputSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
        inputSingleSelect.setGroupNums(2);
        inputSingleSelect.setGroupTitle(LocaleUtil.getMobileTextByKey(locale, "选择日历"));
        List<InputGroupSingleSelectOption> groupList = new ArrayList<>(digiwinAtmcCalendars.size());
        String ownerUserName = "";
        String ownerUserId = "";
        for (DigiwinAtmcCalendar digiwinAtmcCalendar : digiwinAtmcCalendars) {
            InputGroupSingleSelectOption singleSelectOption = new InputGroupSingleSelectOption();
            //是否需要添加到集合里面
            Boolean isNeedAddCollections = false;
            //默认为我的行事历
            if (digiwinAtmcCalendar.getType() == 0) {
                singleSelectOption.setGroupNo(String.valueOf(digiwinAtmcCalendar.getType()));
                singleSelectOption.setGroupName(LocaleUtil.getMobileTextByKey(locale, "我的日历"));
                List<InputSingleSelectOption> optionList = singleSelectOption.getOptionList();
                if (optionList == null) {
                    optionList = new ArrayList<>();
                }
                InputSingleSelectOption selectOption = new InputSingleSelectOption();
                selectOption.setId(String.valueOf(digiwinAtmcCalendar.getId()));
                selectOption.setName(digiwinAtmcCalendar.getName());
                selectOption.setSelected(true);
                selectOption.setBackgroundColor("#f2f2f2");
                //设置规则，选择完行事历，会给到对应参数
                RelationRule relationRule = new RelationRule();
                List<CommonRule> ruleList = relationRule.getRuleList();
                //选择我的日历，则将对应参数带过去
                CommonRule commonRule = new CommonRule();
                commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                commonRule.setTargetSchema("executorList");
                ownerUserName = digiwinAtmcCalendar.getOwnerUserName();
                ownerUserId = digiwinAtmcCalendar.getOwnerUserId();
                commonRule.setTargetText(ownerUserName);
                commonRule.setTargetSelectId(ownerUserId);
                commonRule.setTargetHidden(true);
                commonRule.setTargetEnable(true);
                commonRule.setTargetRequired(false);
                ruleList.add(commonRule);
                relationRule.setRuleList(ruleList);
                selectOption.setRelationRule(relationRule);
                optionList.add(selectOption);
                singleSelectOption.setOptionList(optionList);
                isNeedAddCollections = true;
                inputSingleSelect.setText(String.valueOf(digiwinAtmcCalendar.getId()));
            } else {
                singleSelectOption.setGroupNo(String.valueOf(digiwinAtmcCalendar.getType()));
                singleSelectOption.setGroupName(LocaleUtil.getMobileTextByKey(locale, "团队日历"));
                List<InputSingleSelectOption> optionList = singleSelectOption.getOptionList();
                if (optionList == null) {
                    optionList = new ArrayList<>();
                }
                InputSingleSelectOption selectOption = new InputSingleSelectOption();
                selectOption.setId(String.valueOf(digiwinAtmcCalendar.getId()));
                selectOption.setName(digiwinAtmcCalendar.getName());
                selectOption.setSelected(false);
                selectOption.setBackgroundColor("#f2f2f2");
                //设置规则，选择完行事历，会给到对应参数
                RelationRule relationRule = new RelationRule();
                List<CommonRule> ruleList = relationRule.getRuleList();
                //选择我的日历，则将对应参数带过去
                CommonRule commonRule = new CommonRule();
                commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                commonRule.setTargetSchema("executorList");
                //选择团队行事历，默认也是自己本人
                commonRule.setTargetText(ownerUserName);
                commonRule.setTargetSelectId(ownerUserId);
                commonRule.setTargetHidden(false);
                commonRule.setTargetEnable(true);
                commonRule.setTargetRequired(true);
                ruleList.add(commonRule);
                relationRule.setRuleList(ruleList);
                selectOption.setRelationRule(relationRule);
                isNeedAddCollections = true;
                for (InputGroupSingleSelectOption option : groupList) {
                    if (option.getGroupNo().equals(String.valueOf(digiwinAtmcCalendar.getType()))) {
                        option.getOptionList().add(selectOption);
                        isNeedAddCollections = false;
                        break;
                    }
                }
                if (isNeedAddCollections) {
                    optionList.add(selectOption);
                    singleSelectOption.setOptionList(optionList);
                }
            }
            if (isNeedAddCollections) {
                groupList.add(singleSelectOption);
            }
        }
        inputSingleSelect.setEnable(true);
        inputSingleSelect.setRequired(false);
        inputSingleSelect.setHidden(false);
        inputSingleSelect.setGroupList(groupList);
        return inputSingleSelect;
    }

    @Override
    public String returnComponentType() {
        return InputGroupSingleSelect.COMPONENT_TYPE;
    }
}
