package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * @author wuyang
 * @date 2022/5/26
 */
@Component
public class InputGroupSingleSelectParamAnalyzer implements ComponentParamAnalyzer<InputSingleSelect, String> {
    @Override
    public String getComponentType() {
        return InputGroupSingleSelect.COMPONENT_TYPE;
    }

    @Override
    public Class<InputSingleSelect> getSubmitParamType() {
        return InputSingleSelect.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        InputSingleSelect inputSingleSelect = (InputSingleSelect) submitParam;
        return Optional.ofNullable(inputSingleSelect.getSelectId()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
    }
}