package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotFieldOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 单选组件（类似RadioButton）
 *
 * @author zhangjj
 * @date 2021/7/13 0013 15:40
 */
@Data
public class InputSingleSelect extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 6972346358871849203L;
    public static final String COMPONENT_TYPE = "SINGLE_SELECT";

    private List<InputSingleSelectOption> optionList;

    private String selectId;

    /**
     * 组件标题
     */
    private String title;

    // 设计器新增属性
    /**
     * 1 单选 2 多选
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectTypeEnum
     */
    private Integer showType;
    // 提供给前端字段----冗余字段，因前端使用type、设计器使用showType
    private Integer type;
    /**
     * 样式: 1 check带圆圈  2 整行选中
     */
    private Integer showStyle;

    /**
     * 排列方式 1是上下排列 2是左右排列
     */
    private Integer styleType;

    public Integer getType() {
        return getShowType();
    }

    public static InputSingleSelect create(UiBotLayout uiBotFieldLayout, List<UiBotRule> uiBotRuleList) {
        InputSingleSelect inputSingleSelect = new InputSingleSelect();
        inputSingleSelect.setTitle(uiBotFieldLayout.getHeaderName());
        List<InputSingleSelectOption> optionList = new ArrayList<>();
        List<UiBotFieldOption> uiBotFieldOptionList = uiBotFieldLayout.getOptions();
        if (uiBotFieldOptionList != null && !uiBotFieldOptionList.isEmpty()) {
            for (UiBotFieldOption uiBotFieldOption : uiBotFieldOptionList) {
                InputSingleSelectOption option = new InputSingleSelectOption();
                option.setId(uiBotFieldOption.getValue().toString());
                option.setName(uiBotFieldOption.getTitle());
                optionList.add(option);
            }
        }
        inputSingleSelect.setSchema(uiBotFieldLayout.getSchema());
        //必填设置
        Optional<UiBotRule> uiBotRuleOptional = uiBotRuleList.stream().filter(uiBotRule ->
                uiBotFieldLayout.getSchema().equalsIgnoreCase(uiBotRule.getSchema())
                        && "required".equalsIgnoreCase(uiBotRule.getKey())
        ).findFirst();
        inputSingleSelect.setRequired(uiBotRuleOptional.isPresent());
        inputSingleSelect.setOptionList(optionList);
        return inputSingleSelect;
    }


    @Override
    public String returnComponentType() {
        return InputSingleSelect.COMPONENT_TYPE;
    }
}
