package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * @author zhangjj
 * @date 2021/7/13 0013 15:40
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class InputSingleSelectOption implements Serializable {

    private static final long serialVersionUID = -6427155522950821404L;
    private String id;
    private String name;
    private boolean selected;
    private RelationRule relationRule;
    /**
     * 背景色.格式支持RGB或ARGB的HEX值，前端会判断若没有A则在前面补上FF。如
     * 1. 后端给#C6C6C6，前端使用时则会变成#FFC6C6C6
     * 2. 后端给#0089A0CA
     */
    private String backgroundColor;

    private Action action;

    //多语言
    private langData lang;

    @Data
    public static
    class langData {
        private Map<String, String> name;
    }

    public static InputSingleSelectOption create(String id, String name, boolean selected) {
        InputSingleSelectOption option = new InputSingleSelectOption();
        option.setId(id);
        option.setName(name);
        option.setSelected(selected);
        return option;
    }
}
