package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zhangjj
 * @date 2021/7/13 0013 15:50
 */
@Component
public class InputSingleSelectParamAnalyzer implements ComponentParamAnalyzer<InputSingleSelect, String> {
    @Override
    public String getComponentType() {
        return InputSingleSelect.COMPONENT_TYPE;
    }

    @Override
    public Class<InputSingleSelect> getSubmitParamType() {
        return InputSingleSelect.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        InputSingleSelect inputSingleSelect = (InputSingleSelect) submitParam;
        return Optional.ofNullable(inputSingleSelect.getSelectId()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
        Map<String, Object> displayParam = (Map<String, Object>) pageData.get(pageDataKey);
        List<Map<String, Object>> optionList = (List<Map<String, Object>>) displayParam.get("optionList");
        if (optionList != null && !optionList.isEmpty()) {
            for (Map<String, Object> option : optionList) {
                option.put("name", LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), (String) option.get("name")));
            }
        }
    }
}
