package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspEnumerateResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotFieldOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditorOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * SingleSelectList弹窗单选
 *
 * @author Liux
 * @date 2022年7月12日16点50分
 */
@Data
public class SingleSelectList extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 630883404159875793L;
    public static final String COMPONENT_TYPE = "SINGLE_SELECT_LIST";


    @Override
    public String returnComponentType() {
        return SingleSelectList.COMPONENT_TYPE;
    }

    private List<SingleSelectListOption> optionList = new ArrayList<>();
    //列表样式,1：进度回报样式
    private Integer style;
    //标题
    private String title;
    private String selectId;
    private String text;
    /**
     * 1.单选；2.多选
     */
    private Integer type = 1;
    /**
     * 开窗请求接口，post请求
     */
    private String url;
    private Map<String, Object> rawData;
    /**
     * 多选时选中的id
     */
    private List<String> selectIdList = new ArrayList<>();
    /**
     * 多选时选中的文字
     */
    private List<String> textList = new ArrayList<>();

    /**
     * 是否显示说明
     */
    private Boolean isShowDesc = false;
    /**
     * 说明内容
     */
    private List<String> descPics;

    /**
     * 在途宝应用定制
     *
     * @param title
     * @param url
     * @param selectIdList
     * @param textList
     * @param rawData
     * @param type
     * @return
     */
    public static SingleSelectList createOnTexts(String title, String url, List<String> selectIdList,
                                                 List<String> textList, Map<String, Object> rawData,
                                                 Integer type) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(type);
        selectList.setType(type);
        selectList.setUrl(url);
        selectList.setTextList(textList);
        selectList.setSelectIdList(selectIdList);
        selectList.setRawData(rawData);
        selectList.setRequired(true);
        return selectList;
    }

    /**
     * 在途宝应用定制
     *
     * @param title
     * @param url
     * @param selectId
     * @param text
     * @param rawData
     * @param type
     * @param relationRule
     * @return
     */
    public static SingleSelectList createOnText(String title, String url, String selectId,
                                                String text, Map<String, Object> rawData,
                                                Integer type, RelationRule relationRule) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setType(type);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setUrl(url);
        selectList.setSelectId(selectId);
        selectList.setText(text);
        selectList.setRawData(rawData);
        selectList.setRelationRule(relationRule);
        selectList.setRequired(true);
        return selectList;
    }

    /**
     * 在途宝应用定制。根据在途宝的枚举类创建
     *
     * @param enumerateInfo
     * @param title
     * @return
     */
    public static SingleSelectList createByZtbEnum(List<DigiwinEspEnumerateResponse> enumerateInfo,
                                                   String title, String selectId, String text) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(true);
        List<SingleSelectListOption> optionList = selectList.getOptionList();
        for (DigiwinEspEnumerateResponse enumerateResponse : enumerateInfo) {
            SingleSelectListOption option = new SingleSelectListOption();
            option.setId(enumerateResponse.getEnumerateNo());
            option.setText(enumerateResponse.getEnumerateName());
            optionList.add(option);
        }
        selectList.setText(text);
        selectList.setSelectId(text);
        return selectList;
    }

    public static SingleSelectList createByAPC(List<Map<String, Object>> datas,
                                               String title, String selectId, String text,
                                               String local, boolean required,
                                               boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(required);
        selectList.setEnable(enable);
        List<SingleSelectListOption> optionList = selectList.getOptionList();
        for (Map<String, Object> data : datas) {
            SingleSelectListOption option = new SingleSelectListOption();
            option.setId((String) data.get("layout_no"));
            option.setText((String) data.get("layout_name"));
            if (ObjectUtils.nullSafeEquals(selectId, data.get("layout_no"))) {
                option.setSelected(true);
            }
            optionList.add(option);
        }
        selectList.setText(text);
        selectList.setSelectId(selectId);

        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        selectList.setPlaceholder(localeService.getLanguageValue(local, "请选择"));

        List<CommonRule> ruleList = new ArrayList<>(1);
        RelationRule rule = new RelationRule();
        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
        commonRule.setTargetSchema("area_name");
        commonRule.setTargetSelectId("");
        commonRule.setTargetText("");
        commonRule.setTargetSelectList(Collections.emptyList());
        ruleList.add(commonRule);
        rule.setRuleList(ruleList);
        selectList.setRelationRule(rule);
        return selectList;
    }

    public static SingleSelectList createByTbds(List<Map<String, Object>> datas,
                                                String idSchema, String valueSchema,
                                                String title, String selectId, String text,
                                                boolean required,
                                                boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(required);
        selectList.setEnable(enable);
        List<SingleSelectListOption> optionList = selectList.getOptionList();
        for (Map<String, Object> data : datas) {
            SingleSelectListOption option = new SingleSelectListOption();
            option.setId((String) data.get(idSchema));
            option.setText((String) data.get(valueSchema));
            if (selectId.equalsIgnoreCase((String) data.get(idSchema))) {
                option.setSelected(true);
            }
            optionList.add(option);
        }
        selectList.setText(text);
        selectList.setSelectId(selectId);
        return selectList;
    }

    @Deprecated
    public static SingleSelectList create(String title, String url) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(true);
        return selectList;
    }

    /**
     * 在途宝应用定制
     *
     * @param title
     * @param url
     * @param isShowDesc
     * @param descPics
     * @return
     */
    public static SingleSelectList create(String title, String url, Boolean isShowDesc, List<String> descPics) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(true);
        selectList.setIsShowDesc(Optional.ofNullable(isShowDesc).orElse(false));
        selectList.setDescPics(Optional.ofNullable(descPics).orElse(new ArrayList<>()));
        return selectList;
    }

    @Deprecated
    public static SingleSelectList create(String title, String url, String text) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setText(text);
        selectList.setSelectId(text);
        selectList.setRequired(true);
        return selectList;
    }

    /**
     * 在途宝应用定制
     *
     * @param title
     * @param url
     * @param text
     * @param isShowDesc
     * @param descPics
     * @return
     */
    public static SingleSelectList create(String title, String url, String text, Boolean isShowDesc, List<String> descPics) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setText(text);
        selectList.setSelectId(text);
        selectList.setRequired(true);
        selectList.setIsShowDesc(Optional.ofNullable(isShowDesc).orElse(false));
        selectList.setDescPics(Optional.ofNullable(descPics).orElse(new ArrayList<>()));
        return selectList;
    }

    public static SingleSelectList create(ParseFieldData fieldData, List<UiBotRule> ruleList, int style) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(fieldData.getLabel());
        selectList.setStyle(style);
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> fieldData.getSchema().equalsIgnoreCase(uiBotRule.getSchema()))
                    .forEach(uiBotRule -> {
                        if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                            selectList.setRequired("required".equalsIgnoreCase(uiBotRule.getKey()));
                        }
                    });
        }
        List<UiBotTableColumnEditorOption> options = fieldData.getOptions();
        for (UiBotTableColumnEditorOption option : options) {
            SingleSelectListOption listOption = new SingleSelectListOption();
            listOption.setId(String.valueOf(option.getValue()));
            listOption.setText(option.getTitle());
            if (String.valueOf(option.getValue()).equals(String.valueOf(fieldData.getData()))) {
                listOption.setSelected(true);
            }
            selectList.optionList.add(listOption);
        }
        return selectList;
    }

    public static SingleSelectList create(UiBotLayout layout, String selectId, boolean required) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(layout.getHeaderName() == null ? layout.getPlaceholder() : layout.getHeaderName());
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(required);
        selectList.setSelectId(selectId);
        List<SingleSelectListOption> optionList = selectList.getOptionList();
        List<UiBotFieldOption> options = layout.getOptions();
        for (UiBotFieldOption option : options) {
            SingleSelectListOption selectListOption = new SingleSelectListOption();
            String id = (String) option.getValue();
            String text = option.getTitle();
            selectListOption.setId(id);
            if (selectId.equals(id)) {
                selectList.setText(text);
                selectListOption.setSelected(true);
            }
            selectListOption.setText(text);
            optionList.add(selectListOption);
        }
        return selectList;
    }

    public static SingleSelectList createSingleSelectList(List<SingleSelectListOption> optionList,
                                                          String title, String selectId, String text,
                                                          String local, boolean required,
                                                          boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(required);
        selectList.setEnable(enable);
        selectList.setSelectId(selectId);
        selectList.setText(text);
        selectList.setOptionList(optionList);
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        selectList.setPlaceholder(localeService.getLanguageValue(local, "请选择"));
        return selectList;
    }

    public static SingleSelectList createMultiSelectList(List<SingleSelectListOption> optionList,
                                                          String title, List<String> selectIdList, List<String> textList,
                                                          String local, boolean required,
                                                          boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(required);
        selectList.setEnable(enable);
        selectList.setSelectIdList(selectIdList);
        selectList.setTextList(textList);
        selectList.setOptionList(optionList);
        selectList.setType(2);
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        selectList.setPlaceholder(localeService.getLanguageValue(local, "请选择"));
        return selectList;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        if (2 == this.type) {
            List valList = JsonUtil.objectToJavaObject(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema), List.class);
            if (CollectionUtils.isEmpty(valList)) {
                if (!CollectionUtils.isEmpty(this.optionList)) {
                    this.selectIdList = this.optionList.stream().filter(option -> !ObjectUtils.isEmpty(option.getSelected()) && BooleanUtils.isTrue(option.getSelected())).map(option -> option.getId()).collect(Collectors.toList());
                }
                if (BooleanUtils.isTrue(this.enable)) {
                    // 输入型，暂定无默认值
                } else {
                    this.text = "-";
                }
            } else {
                this.textList = this.optionList.stream().filter(e -> valList.contains(e.getId())).map(e -> e.getText()).collect(Collectors.toList());
                this.selectIdList = valList;
            }
        } else {
            String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema))
                    .map(Object::toString)
                    .orElse(null);
            if (StringUtils.hasLength(value)) {
                this.selectId = value;
                if (!CollectionUtils.isEmpty(this.optionList)) {
                    Optional<SingleSelectListOption> found = Optional.empty();
                    for (SingleSelectListOption r : optionList) {
                        if (value.equals(r.getId())) {
                            r.setSelected(true);
                            found = Optional.of(r);
                        } else {
                            r.setSelected(false);
                        }
                    }
                    this.text = found
                            .map(SingleSelectListOption::getText)
                            .orElse("");
                }
            } else {
                //是否默认选中
                if (!CollectionUtils.isEmpty(this.optionList)) {
                    this.optionList.stream().filter(option -> !ObjectUtils.isEmpty(option.getSelected()) && BooleanUtils.isTrue(option.getSelected())).forEachOrdered(option -> {
                        this.selectId = option.getId();
                        this.text = option.getText();
                    });
                }
                if (BooleanUtils.isTrue(this.enable)) {
                    // 输入型，暂定无默认值
                } else {
                    this.text = "-";
                }
            }
        }

        //提示语给默认值
        if(org.apache.commons.lang3.ObjectUtils.isEmpty(this.placeholder)){
            this.placeholder = localeService.getLanguageValue(executeContext.getLocale(), "请选择");
        }
    }
}
