package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author Liux
 * @date 2022年7月12日16点49分
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class SingleSelectListOption implements Serializable {

    private static final long serialVersionUID = 4477970003779508482L;
    private String id;
    //选项内容
    private String text;
    //内容单位,如：%
    private String textUnit;
    //选中，默认只能有一个为true
    private Boolean selected;
    //该值是否需要校验,默认只能有一个为true
    private Boolean hasCheck;
    //校验提示语,只有当hasCheck为true，触发提示
    private String checkTip;
    /**
     * 是否置灰
     */
    private Boolean enable;

    public static SingleSelectListOption create(int value, Boolean selected, Boolean hasCheck, int hasCheckValue, String checkTip) {
        SingleSelectListOption singleSelectListOption = new SingleSelectListOption();
        singleSelectListOption.setId(UUIDUtil.getUuid());
        singleSelectListOption.setText(String.valueOf(value));
        singleSelectListOption.setTextUnit("%");
        singleSelectListOption.setSelected(selected);
        if (hasCheck && hasCheckValue == value) {
            hasCheck = true;
            singleSelectListOption.setCheckTip(checkTip);
        } else {
            hasCheck = false;
        }
        singleSelectListOption.setHasCheck(hasCheck);

        return singleSelectListOption;
    }

    public static SingleSelectListOption create(String id, String text, Boolean enable) {
        SingleSelectListOption option = new SingleSelectListOption();
        option.setId(id);
        option.setText(text);
        option.setEnable(enable);
        return option;
    }

    public static SingleSelectListOption create(int value, Boolean selected, Boolean hasCheck, int hasCheckValue, String checkTip, String textUnit) {
        SingleSelectListOption singleSelectListOption = new SingleSelectListOption();
        singleSelectListOption.setId(UUIDUtil.getUuid());
        singleSelectListOption.setText(String.valueOf(value));
        if (StringUtils.isNotEmpty(textUnit)) {
            singleSelectListOption.setTextUnit(textUnit);
        }
        singleSelectListOption.setSelected(selected);
        if (hasCheck && hasCheckValue == value) {
            hasCheck = true;
            singleSelectListOption.setCheckTip(checkTip);
        } else {
            hasCheck = false;
        }
        singleSelectListOption.setHasCheck(hasCheck);

        return singleSelectListOption;
    }

    /**
     * 进度回报：数量转移
     *
     * @param value
     * @param selected
     * @param hasCheck
     * @param hasCheckValue
     * @param checkTip
     * @return
     */
    public static SingleSelectListOption transferQuantityCreate(int value, Boolean selected, Boolean hasCheck, int hasCheckValue, String checkTip) {
        SingleSelectListOption singleSelectListOption = new SingleSelectListOption();
        singleSelectListOption.setId(UUIDUtil.getUuid());
        singleSelectListOption.setText(String.valueOf(value));
        singleSelectListOption.setSelected(selected);
        if (hasCheck && hasCheckValue == value) {
            hasCheck = true;
            singleSelectListOption.setCheckTip(checkTip);
        } else {
            hasCheck = false;
        }
        singleSelectListOption.setHasCheck(hasCheck);

        return singleSelectListOption;
    }
}
