package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * <p>功能描述：附件组件参数解析器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AttachmentParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/6/22 23:37
 */
@Component("singleSelectListParamAnalyzer")
public class SingleSelectListParamAnalyzer implements ComponentParamAnalyzer<SingleSelectList, Object> {

    private static final Logger logger = LoggerFactory.getLogger(SingleSelectListParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return SingleSelectList.COMPONENT_TYPE;
    }

    @Override
    public Class<SingleSelectList> getSubmitParamType() {
        return SingleSelectList.class;
    }

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public Object analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof SingleSelectList)) {
            logger.debug("submitParam is not instanceof SingleSelectList component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        SingleSelectList selectList = (SingleSelectList) submitParam;
        if (SingleSelectTypeEnum.SINGLE_SELECT.getValue().equals(selectList.getType())) {
            return Optional.ofNullable(selectList.getSelectId()).orElse("");
        } else {
            return selectList.getSelectIdList();
        }
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {

    }
}
