package com.digiwin.mobile.mobileuibot.core.component.input.singletext;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputSingleParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/25 20:25
 */
@Component("inputSingleParamAnalyzer")
public class InputSingleParamAnalyzer implements ComponentParamAnalyzer<InputSingleText, String> {

    private static final Logger logger = LoggerFactory.getLogger(InputSingleParamAnalyzer.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public String getComponentType() {
        return InputSingleText.COMPONENT_TYPE;
    }

    @Override
    public Class<InputSingleText> getSubmitParamType() {
        return InputSingleText.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputSingleText)) {
            logger.debug("submitParam is not instanceof InputSingleText component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return "";
        }
        InputSingleText inputSingleText = (InputSingleText) submitParam;
        return Optional.ofNullable(inputSingleText.getText()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {
        Map<String, Object> displayParam = (Map<String, Object>) pageData.get(pageDataKey);
        String placeholder = (String) displayParam.get("placeholder");
        Boolean required = (Boolean) displayParam.get("required");
        String text = (String) displayParam.get("text");
        String title = (String) displayParam.get("title");

        // 处理多语言
        displayParam.put("placeholder", localeService.getLanguageValue(apiRequest.getLocale(), placeholder));
        displayParam.put("title", localeService.getLanguageValue(apiRequest.getLocale(), title));
    }
}
