package com.digiwin.mobile.mobileuibot.core.component.input.standardentry;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * ztb录入组件
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ZtbCargoInfoEntry extends BaseInputMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "ZTB_CARGO_INFO_ENTRY";
    private static final long serialVersionUID = -8177256212617136672L;

    private String title;
    /**
     * 是否能新增
     */
    private Boolean canAppend = true;
    /**
     * 默认保留的组件数
     */
    private Integer defalutNum = 1;

    /**
     *
     */
    private List<InputStandardEntryColumn> dataList = new ArrayList<>(6);

    public static ZtbCargoInfoEntry createZtbCargoInformation(String locale, LocaleService localeService, String schema) {
        ZtbCargoInfoEntry ztbCargoInfoEntry = new ZtbCargoInfoEntry();
        ztbCargoInfoEntry.setCanAppend(true);
        ztbCargoInfoEntry.setDefalutNum(1);
        ztbCargoInfoEntry.setTitle(localeService.getLanguageValue(locale, "货物信息"));
        List<InputStandardEntryColumn> dataList = ztbCargoInfoEntry.getDataList();
        InputStandardEntryColumn column = new InputStandardEntryColumn();
        List<CardContent> contents = column.getColumn();
        contents.add(new CardContent(localeService.getLanguageValue(locale, "品号"), "", "item_no", localeService.getLanguageValue(locale, "请输入"), "TEXT", true));
        contents.add(new CardContent(localeService.getLanguageValue(locale, "品名"), "", "item_name", localeService.getLanguageValue(locale, "请输入"), "TEXT", true));
        contents.add(new CardContent(localeService.getLanguageValue(locale, "数量"), "", 0, "delivery_qty", localeService.getLanguageValue(locale, "请输入"), "PRICE", true, "", localeService.getLanguageValue(locale, "单位")));
        dataList.add(column);
        return ztbCargoInfoEntry;
    }

    @Override

    public String returnComponentType() {
        return ZtbCargoInfoEntry.COMPONENT_TYPE;
    }
}
