package com.digiwin.mobile.mobileuibot.core.component.input.standardentry;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ztbCargoInfoEntryParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/25 20:25
 */
@Component("ztbCargoInfoEntryParamAnalyzer")
public class ZtbCargoInfoEntryParamAnalyzer implements ComponentParamAnalyzer<ZtbCargoInfoEntry, List<InputStandardEntryColumn>> {

    private static final Logger logger = LoggerFactory.getLogger(ZtbCargoInfoEntryParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return ZtbCargoInfoEntry.COMPONENT_TYPE;
    }

    @Autowired
    private LocaleService localeService;

    @Override
    public Class<ZtbCargoInfoEntry> getSubmitParamType() {
        return ZtbCargoInfoEntry.class;
    }

    @Override
    public List<InputStandardEntryColumn> analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof List)) {
            logger.debug("submitParam is not instanceof Attachment component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return Collections.emptyList();
        }
        return ModuleUtils.listMapToListObject((List<?>) submitParam, InputStandardEntryColumn.class);
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {
    }
}
