package com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 开关组件
 *
 * @author zhangjj
 * @date 2021/11/3 0003 11:25
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class InputSwitch extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 4941580150271270258L;
    public static final String COMPONENT_TYPE = "INPUT_SWITCH";
    public static final String SWITCH_OPEN = "1";
    public static final String SWITCH_CLOSED = "0";

    /**
     * 初始状态，0为关闭，1为打开
     */
    public Integer state;

    /**
     * 组件标题
     */
    public String title;

    /**
     * 最终选择结果状态，0为关闭，1为打开
     */
    public Integer switchState;
    /**
     * 描述说明
     */
    private String content;

    public static InputSwitch create(UiBotLayout uiBotFieldLayout, String locale) {
        InputSwitch inputSwitch = new InputSwitch();
        inputSwitch.setState(InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState());
        if (uiBotFieldLayout != null) {
            inputSwitch.setTitle(uiBotFieldLayout.getHeaderName());
            ///todo pc端字段名称是状态，这里写死为-特别关注
            if ("importance".equals(uiBotFieldLayout.getSchema())) {
                inputSwitch.setTitle(LocaleUtil.getMobileTextByKey(locale, "特别关注"));
            }
        }
        return inputSwitch;
    }

    public static InputSwitch create(String title, String selectDate) {
        InputSwitch inputSwitch = new InputSwitch();
        inputSwitch.setState(InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState());
        LocalDateTime now;
        if (StringUtils.hasLength(selectDate)) {
            now = DateTimeUtil.parseUseDefaultPattern(selectDate);
        } else {
            now = LocalDateTime.now();
        }
        InputDateTime openStartTime = new InputDateTime(
                now.getYear() + "",
                DateTimeUtil.getFullMonth(now.getMonthValue()),
                DateTimeUtil.getFullDate(now.getDayOfMonth()),
                "00",
                "00"
        );
        openStartTime.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
        InputDateTime openEndTime = new InputDateTime(
                now.getYear() + "",
                DateTimeUtil.getFullMonth(now.getMonthValue()),
                DateTimeUtil.getFullDate(now.getDayOfMonth()),
                "23",
                "59"
        );
        openEndTime.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
        InputDateTime closedStartTime = setInputDt(now, 1);
        InputDateTime closedEndTime = setInputDt(now, 2);

        //设置规则，打开/关闭开关，变化开始或者结束时间
        RelationRule relationRule = new RelationRule();
        setRelationRule(relationRule, "startTime", null, "1", 1, openStartTime);
        setRelationRule(relationRule, "startTime", null, "0", 1, new InputDateTime());
        setRelationRule(relationRule, "actualStartTime", null, "1", 1, openStartTime);
        setRelationRule(relationRule, "actualStartTime", null, "0", 1, new InputDateTime());
        setRelationRule(relationRule, "endTime", "startTime", "1", 1, openEndTime);
        setRelationRule(relationRule, "endTime", null, "0", 1, new InputDateTime());
        addRelationRule(relationRule, "endTime", "startTime", 1);
        setRelationRule(relationRule, "actualEndTime", "actualStartTime", "1", 1, openEndTime);
        setRelationRule(relationRule, "actualEndTime", null, "0", 1, new InputDateTime());
        addRelationRule(relationRule, "actualEndTime", "actualStartTime", 1);

        inputSwitch.setRelationRule(relationRule);

        inputSwitch.setTitle(title);
        inputSwitch.setEnable(true);
        inputSwitch.setHidden(false);
        inputSwitch.setRequired(false);
        return inputSwitch;
    }

    private static void addRelationRule(RelationRule relationRule, String targetSchema, String schema, int condition) {
        List<CommonRule> ruleList = relationRule.getRuleList();

        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(condition);
        commonRule.setTargetSchema(targetSchema);
        List<TargetDatetime> targetDatetimes = new ArrayList<>(1);
        TargetDatetime targetDatetime = new TargetDatetime();
        targetDatetime.setDatetimeType(1);
        targetDatetime.setLinkageSchema(schema);
        targetDatetimes.add(targetDatetime);
        commonRule.setTargetHidden(false);
        commonRule.setTargetEnable(true);
        commonRule.setTargetDatetime(targetDatetimes);
        ruleList.add(commonRule);
        relationRule.setRuleList(ruleList);
    }

    private static RelationRule setRelationRule(RelationRule relationRule, String targetSchema, String schema, String switchType, int condition, InputDateTime dateTime) {
        List<CommonRule> ruleList = relationRule.getRuleList();

        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(condition);
        commonRule.setTargetSchema(targetSchema);
        commonRule.setSwitchType(switchType);
        List<TargetDatetime> targetDatetimes = new ArrayList<>(1);
        TargetDatetime targetDatetime = new TargetDatetime();

        if (SWITCH_CLOSED.equals(switchType)) {
            targetDatetime.setDatetimeType(4);
        } else {
            targetDatetime.setDatetimeType(3);
            dateTime.setType(InputDateTimePickerTypeEnum.HOUR_MINUTE.getType());
        }
        if (schema != null) {
            targetDatetime.setLinkageSchema(schema);
        } else {
            targetDatetime.setLinkageSchema(targetSchema);
        }
        commonRule.setTargetData(dateTime);
        targetDatetimes.add(targetDatetime);
        commonRule.setTargetDatetime(targetDatetimes);
        commonRule.setTargetHidden(false);
        commonRule.setTargetEnable(true);
        ruleList.add(commonRule);
        relationRule.setRuleList(ruleList);
        return relationRule;
    }

    private static InputDateTime setInputDt(LocalDateTime now, int addTime) {
        InputDateTime nowInputDt;
        if (LocalDateTime.now().getMinute() != 0) {
            nowInputDt = new InputDateTime(
                    now.getYear() + "",
                    DateTimeUtil.getFullMonth(now.getMonthValue()),
                    DateTimeUtil.getFullDate(now.getDayOfMonth()),
                    DateTimeUtil.getFullHour(LocalDateTime.now().getHour() + addTime),
                    "00"
            );
        } else {
            nowInputDt = new InputDateTime(
                    now.getYear() + "",
                    DateTimeUtil.getFullMonth(now.getMonthValue()),
                    DateTimeUtil.getFullDate(now.getDayOfMonth()),
                    DateTimeUtil.getFullHour(LocalDateTime.now().getHour() + addTime - 1),
                    "00"
            );
        }
        return nowInputDt;
    }

    public static InputSwitch create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList,
                                     Map<String, Object> bizData, List<Rule> mobileRuleList) {
        InputSwitch inputSwitch = new InputSwitch();
        //将true给1，false给0
        Integer is_approve = "false".equalsIgnoreCase(String.valueOf(bizData.get(column.getSchema()))) ? 0 : 1;
        inputSwitch.setState(is_approve);
        if (column != null) {
            inputSwitch.setTitle(column.getHeaderName());
        }
        return inputSwitch;
    }

    public static InputSwitch create(Boolean data, String headerName) {
        InputSwitch inputSwitch = new InputSwitch();
        //将true给1，false给0
        if (data) {
            inputSwitch.setState(1);
        } else {
            inputSwitch.setState(0);
        }
        inputSwitch.setTitle(headerName);
        return inputSwitch;
    }

    public static InputSwitch createByAbiCondition(Boolean data, String headerName, String targetSchema) {
        InputSwitch inputSwitch = new InputSwitch();
        //将true给1，false给0
        if (data) {
            inputSwitch.setState(1);
        } else {
            inputSwitch.setState(0);
        }
        inputSwitch.setEnable(true);
        inputSwitch.setRequired(false);
        inputSwitch.setTitle(headerName);
        RelationRule relationRule = new RelationRule();
        List<CommonRule> ruleList = relationRule.getRuleList();
        CommonRule commonRuleOpen = new CommonRule();
        commonRuleOpen.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRuleOpen.setTargetSchema(targetSchema);
        commonRuleOpen.setSwitchType(SWITCH_OPEN);
        commonRuleOpen.setTargetHidden(false);
        commonRuleOpen.setTargetEnable(true);
        commonRuleOpen.setTargetRequired(true);
        ruleList.add(commonRuleOpen);

        CommonRule commonRuleClose = new CommonRule();
        commonRuleClose.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRuleClose.setTargetSchema(targetSchema);
        commonRuleClose.setSwitchType(SWITCH_CLOSED);
        commonRuleClose.setTargetHidden(true);
        commonRuleClose.setTargetEnable(false);
        commonRuleClose.setTargetRequired(false);
        ruleList.add(commonRuleClose);

        inputSwitch.setRelationRule(relationRule);
        return inputSwitch;
    }

    public static InputSwitch create(String schema, Boolean data, String headerName, Boolean enable, List<UiBotRule> ruleList) {
        InputSwitch inputSwitch = new InputSwitch();
        //将true给1，false给0
        if (data) {
            inputSwitch.setState(InputSwitchStateEnum.SWITCH_STATE_OPEN.getState());
        } else {
            inputSwitch.setState(InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState());
        }
        inputSwitch.setTitle(headerName);
        inputSwitch.setEnable(enable == null ? false : enable);
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> schema.equalsIgnoreCase(uiBotRule.getSchema()))
                    .forEach(uiBotRule -> {
                        if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                            inputSwitch.setRequired("required".equalsIgnoreCase(uiBotRule.getKey()));
                        }
                    });
        }
        return inputSwitch;
    }

    public static InputSwitch create(Boolean state, String title, Boolean hidden) {
        InputSwitch inputSwitch = new InputSwitch();
        // 将true给1，false给0
        if (state) {
            inputSwitch.setState(InputSwitchStateEnum.SWITCH_STATE_OPEN.getState());
        } else {
            inputSwitch.setState(InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState());
        }
        inputSwitch.setTitle(title);
        inputSwitch.setHidden(hidden == null ? false : hidden);
        return inputSwitch;
    }

    public static InputSwitch createByZtbCondition(Boolean data, String headerName, String targetSchema, String content) {
        InputSwitch inputSwitch = new InputSwitch();
        //将true给1，false给0
        if (data) {
            inputSwitch.setState(1);
        } else {
            inputSwitch.setState(0);
        }
        inputSwitch.setEnable(true);
        inputSwitch.setRequired(false);
        inputSwitch.setTitle(headerName);
        RelationRule relationRule = new RelationRule();
        List<CommonRule> ruleList = relationRule.getRuleList();
        CommonRule commonRuleOpen = new CommonRule();
        commonRuleOpen.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRuleOpen.setTargetSchema(targetSchema);
        commonRuleOpen.setSwitchType(SWITCH_OPEN);
        commonRuleOpen.setTargetHidden(false);
        commonRuleOpen.setTargetEnable(true);
        commonRuleOpen.setTargetRequired(true);
        ruleList.add(commonRuleOpen);

        CommonRule commonRuleClose = new CommonRule();
        commonRuleClose.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRuleClose.setTargetSchema(targetSchema);
        commonRuleClose.setSwitchType(SWITCH_CLOSED);
        commonRuleClose.setTargetHidden(true);
        commonRuleClose.setTargetEnable(false);
        commonRuleClose.setTargetRequired(false);
        ruleList.add(commonRuleClose);

        inputSwitch.setRelationRule(relationRule);
        inputSwitch.setContent(content);
        return inputSwitch;
    }

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        Object value = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (value == null) {
            this.state = 0;
        } else {
            if (value instanceof Boolean) {
                this.state = (boolean) value ? 1 : 0;
            } else {
                // 其它类型先赋值0，后面具体场景具体分析
                this.state = 0;
            }
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputSwitch inputSwitch = new InputSwitch();
        inputSwitch.setComponentId(rawContent.getComponentId());
        inputSwitch.setTitle(rawContent.getLabel());
        inputSwitch.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.SwitchObj switchObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.SwitchObj.class);
        if (switchObj != null) {
            inputSwitch.setState(switchObj.getState());
        }
        inputSwitch.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputSwitch;
    }
}
