package com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * @author zhangjj
 * @date 2021/11/4 0004 15:35
 */
@Component("inputSwitchParamAnalyzer")
public class InputSwitchParamAnalyzer implements ComponentParamAnalyzer<InputSwitch, Integer> {
    Logger logger = LoggerFactory.getLogger(InputSwitchParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputSwitch.COMPONENT_TYPE;
    }

    @Override
    public Class<InputSwitch> getSubmitParamType() {
        return InputSwitch.class;
    }

    @Override
    public Integer analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputSwitch)) {
            logger.debug("submitParam is not instanceof InputSwitch component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return 0;
        }
        InputSwitch inputSwitch = (InputSwitch) submitParam;
        return Optional.ofNullable(inputSwitch.getSwitchState()).orElse(0);
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
