package com.digiwin.mobile.mobileuibot.core.component.input.windowselect;

import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分组组件buttons中backFills解析
 *
 * @author zhangjj
 * @date 2022/4/1 11:14 AM
 */
public class BackFillsParseUtil {

    /**
     * 获取获取提交参数名对应关系（web中backFills字段）
     *
     * @param buttons
     * @return Map--key为获取到的参数名，value为提交要用的参数名
     */
    public static Map<String, String> getBackFillMap(List buttons) {
        Map<String, String> backFillMap = new HashMap<>();
        if (buttons == null || buttons.isEmpty()) {
            return backFillMap;
        }
        List actions = new ArrayList();
        for (int i = 0; i < buttons.size(); i++) {
            Map<String, Object> button = (Map<String, Object>) buttons.get(i);
            if (button != null && "confirm".equalsIgnoreCase((String) button.get("id"))) {
                actions = (List) button.get("actions");
                break;
            }
        }
        if (actions == null || actions.isEmpty() || actions.get(0) == null) {
            return backFillMap;
        }
        Map<String, Object> action = (Map<String, Object>) actions.get(0);
        List backFills = (List) action.get("backFills");
        if (backFills == null || backFills.isEmpty()) {
            return backFillMap;
        }
        backFills.stream().forEach(backFill -> {
            Map<String, String> backFillObj = (Map<String, String>) backFill;
            String key = backFillObj.get("valueScript");
            String value = backFillObj.get("key");
            //解析valueScript（selectedObject['id']）
            if (key.contains("'")) {
                String[] keys = key.split("'");
                if (keys.length == 3) {
                    key = keys[1];
                }
            }
            backFillMap.put(key, value);
        });
        return backFillMap;
    }

    public static Map<String, Object> getBackFillMap2(List buttons) {
        Map<String, Object> backFillMap = new HashMap<>();
        if (CollectionUtils.isEmpty(buttons)) {
            return backFillMap;
        }
        List actions = new ArrayList();
        for (int i = 0; i < buttons.size(); i++) {
            Map<String, Object> button = (Map<String, Object>) buttons.get(i);
            if (button != null && "confirm".equalsIgnoreCase((String) button.get("id"))) {
                actions = (List) button.get("actions");
                break;
            }
        }
        if (actions == null || actions.isEmpty() || actions.get(0) == null) {
            return backFillMap;
        }
        Map<String, Object> action = (Map<String, Object>) actions.get(0);
        List backFills = (List) action.get("backFills");
        if (backFills == null || backFills.isEmpty()) {
            return backFillMap;
        }
        backFills.stream().forEach(backFill -> {
            Map<String, Object> backFillObj = (Map<String, Object>) backFill;
            Object value = backFillObj.get("valueScript");
            String key = (String) backFillObj.get("key");
            //解析valueScript（selectedObject['id']）
            String valueStr = String.valueOf(value);
            if (valueStr.contains("'")) {
                String[] keys = valueStr.split("'");
                if (keys.length == 3) {
                    value = keys[1];
                }
            }
            backFillMap.put(key, value);
        });
        return backFillMap;
    }
}
