package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.BackFillsParseUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleItemLabel;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineButtonDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * 开窗多选组件
 *
 * @author zhangjj
 * @date 2021/7/13 0013 17:21
 */
@Data
public class InputWindowMultiSelect extends BaseInputMobileComponent implements Serializable {
    public static final String COMPONENT_TYPE = "WINDOW_MULTI_SELECT";
    private static final long serialVersionUID = -6556419365108443785L;

    @Override
    public String returnComponentType() {
        return InputWindowMultiSelect.COMPONENT_TYPE;
    }

    private String title;

    private InputWindowSingleItemLabel titleLabel;

    private String url;

    private String selectId;

    /**
     * 组件样式
     *
     * @see InputWindowSelectStyleEnum
     */
    private Integer style;

    private Map<String, Object> rawData;

    /**
     * 选中的数据列表
     */
    private List<Object> selectDetailList;

    /**
     * 多选的时候选择一个或者多个都放这个list，不要放 selectId
     * 选中的数据id列表
     */
    private List<String> selectIdList;

    /**
     * 选中的数据显示值列表
     */
    private List<String> textList;

    /**
     * 选择的类型，0代表文本，1代表人
     */
    private Integer selectType;

    private final String type = this.returnComponentType();

    /**
     * 最大选择数量
     */
    private Integer maxSelectNum;

    /**
     * 是否支持手动输入
     */
    private Boolean isEdit = false;

    /**
     * 后缀文本
     */
    private String suffixText;

    public InputWindowMultiSelect() {
    }

    public void setType(String type) {
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, String url, String locale, UiBotExecuteContext executeContext) {
        InputWindowMultiSelect windowMultiSelect = new InputWindowMultiSelect();
        if (uiBotFieldLayout != null) {
            windowMultiSelect.setSchema(uiBotFieldLayout.getSchema());
            windowMultiSelect.setTitle(uiBotFieldLayout.getHeaderName());
            windowMultiSelect.setRawData(uiBotFieldLayout.parseExecuteContextToRawData(uiBotFieldLayout, executeContext));
        }
        windowMultiSelect.setType(InputWindowMultiSelect.COMPONENT_TYPE);
        windowMultiSelect.setUrl(url);
        windowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        if (uiBotRule != null) {
            windowMultiSelect.setRequired("required".equals(uiBotRule.getKey()));
        }
        windowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        return windowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule,
                                                List<Map<String, Object>> selectDetailList, String url, String locale, UiBotExecuteContext executeContext) {
        InputWindowMultiSelect windowMultiSelect = new InputWindowMultiSelect();
        if (uiBotFieldLayout != null) {
            windowMultiSelect.setSchema(uiBotFieldLayout.getSchema());
            String title = uiBotFieldLayout.getHeaderName() == null ? uiBotFieldLayout.getPlaceholder() : uiBotFieldLayout.getHeaderName();
            if (StringUtil.isEmpty(title)) {
                title = uiBotFieldLayout.getOperationsTitle(uiBotFieldLayout);
            }
            windowMultiSelect.setTitle(title);
            windowMultiSelect.setRawData(uiBotFieldLayout.parseExecuteContextToRawData(uiBotFieldLayout, executeContext));
        }
        windowMultiSelect.setType(InputWindowMultiSelect.COMPONENT_TYPE);
        windowMultiSelect.setUrl(url);
        windowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        if (uiBotRule != null) {
            windowMultiSelect.setRequired("required".equals(uiBotRule.getKey()));
        }
        if (selectDetailList != null && selectDetailList.size() > 0) {
            List<String> selectIds = new ArrayList<>(selectDetailList.size());
            for (Map<String, Object> selectDetail : selectDetailList) {
                if (!CollectionUtils.isEmpty(uiBotFieldLayout.getRelationSchemas())) {
                    selectIds.add((String) selectDetail.get(uiBotFieldLayout.getRelationSchemas().get(0)));
                } else {
                    selectIds.add((String) selectDetail.get(uiBotFieldLayout.getSchema()));
                }

            }
            windowMultiSelect.setSelectIdList(selectIds);
            windowMultiSelect.setSelectDetailList(Collections.singletonList(selectDetailList));
        }
        windowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        return windowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, String locale, Integer selectType) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
        Map<String, Object> rawData = new HashMap<>();
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputWindowMultiSelect.setType(InputWindowMultiSelect.COMPONENT_TYPE);
        inputWindowMultiSelect.setHidden(true);
        inputWindowMultiSelect.setEnable(true);
        inputWindowMultiSelect.setRequired(true);
        inputWindowMultiSelect.setSelectType(selectType);
        return inputWindowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, Map<String, Object> rawData,
                                                String locale, Integer selectType, Integer style,
                                                Boolean hidden, Boolean required, LocaleService localeService) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(style);
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputWindowMultiSelect.setHidden(hidden);
        inputWindowMultiSelect.setEnable(true);
        inputWindowMultiSelect.setRequired(required);
        inputWindowMultiSelect.setSelectType(selectType);
        return inputWindowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, Map<String, Object> rawData,
                                                String locale, Integer selectType, Integer style,
                                                Boolean hidden, Boolean required,
                                                LocaleService localeService, Boolean enable) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(style);
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputWindowMultiSelect.setHidden(hidden);
        inputWindowMultiSelect.setEnable(enable);
        inputWindowMultiSelect.setRequired(required);
        inputWindowMultiSelect.setSelectType(selectType);
        return inputWindowMultiSelect;
    }

    /**
     * 发起项目：智慧检料
     *
     * @param uiBotLayout
     * @param required
     * @param url
     * @param pcUiBotModel
     * @param enable
     * @param bizData
     * @param request
     * @return
     */
    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, Boolean required,
                                                String url, UiBotModel pcUiBotModel, Boolean enable,
                                                Map<String, Object> bizData, ApiRequest request, String locale) {
        InputWindowMultiSelect windowSingleSelect = new InputWindowMultiSelect();
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        if (uiBotLayout != null) {
            windowSingleSelect.setSchema(uiBotLayout.getSchema());
            windowSingleSelect.setTitle(uiBotLayout.getLabel());
            List<UiBotTableColumnDefinition> columnDefs1 = uiBotLayout.getColumnDefs();
            Map<String, Object> rawData = new HashMap<>(8);
            if (CollUtil.isNotEmpty(columnDefs1)) {
                List<UiBotTableColumnDefinition> columnList = columnDefs1.stream().filter(a ->
                        LocaleUtil.getMobileTextByKey(locale, "品号").equals(a.getHeaderName())).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(columnList)) {
                    for (UiBotTableColumnDefinition uiBotTableColumnDefinition : columnList) {
                        List<UiBotTableColumn> columns = uiBotTableColumnDefinition.getColumns();
                        if (CollUtil.isNotEmpty(columns)) {
                            for (UiBotTableColumn column : columns) {
                                if (CollUtil.isNotEmpty(column.getOperations())) {
                                    JSONObject operation = column.getOperations().getJSONObject(0);
                                    rawData.put("dataSourceSet",
                                            operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("dataSourceSet"));
                                    rawData.put("defaultShow",
                                            operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getBooleanValue("defaultShow"));
                                    JSONObject executeContextObj =
                                            operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("executeContext");
                                    if (executeContextObj != null) {
                                        rawData.put("executeContext", executeContextObj);
                                    } else {
                                        rawData.put("executeContext", executeContext);
                                    }
                                    rawData.put("multipleSelect",
                                            operation.getJSONObject("openWindowDefine").getBooleanValue("multipleSelect"));
                                    rawData.put("selectedFirstRow",
                                            operation.getJSONObject("openWindowDefine").getBooleanValue("selectedFirstRow"));
                                    rawData.put("queryTagSuffix", "DIALOG");
                                    rawData.put("buttons",
                                            operation.getJSONObject("openWindowDefine").getJSONArray("buttons"));
                                    if (bizData != null) {
                                        rawData.put("parameter", bizData);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            windowSingleSelect.setRawData(rawData);
        }
        windowSingleSelect.setRequired(required);
        windowSingleSelect.setType(InputWindowMultiSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(request.getLocale(), "请选择"));
        windowSingleSelect.setEnable(enable != null && enable);
        return windowSingleSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, Map<String, Object> rawData,
                                                String locale, Integer selectType, Integer style,
                                                Boolean hidden, Boolean required, LocaleService localeService, Integer maxSelectNum, String selectId) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(style);
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputWindowMultiSelect.setHidden(hidden);
        inputWindowMultiSelect.setEnable(true);
        inputWindowMultiSelect.setRequired(required);
        inputWindowMultiSelect.setSelectType(selectType);
        inputWindowMultiSelect.setMaxSelectNum(maxSelectNum);
        inputWindowMultiSelect.setSelectIdList(Arrays.asList(selectId.split(";")));
        return inputWindowMultiSelect;
    }


    /**
     * 弹窗 定义 -- 设计器新增属性 -- 24S1迭代 针对开窗配置改造，使用列表。不可删除，兼容历史卡配置
     */
    private PcUiBotTmOperation openWindowDefine;
    /**
     * 开启分页
     */
    private Boolean useHasNext;
    /**
     * 分页参数
     */
    private Integer pageSize;
    /**
     * 开窗列表 定义 -- 设计器新增属性
     */
    private List<PcUiBotTmOperation> operations;
    /**
     * 返回给前端的 开窗配置列表 -- 根据condition为true获取对应的开窗配置
     */
    private List<OpenWindowConfig> openWindowConfigList;

    @Data
    @Accessors(chain = true)
    private static class OpenWindowConfig {
        private String name;
        private String condition;
        private List<Object> selectDetailList;
        private List<String> selectIdList;
        private Map<String, Object> rawData;
        private Boolean useHasNext = false;
        private Integer pageSize = 50;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.url = AppContext.getBaseUrl() + "/data/entry/window/data/list";
        this.openWindowConfigList =
                this.buildOpenWindowConfigList(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData,
                        this.openWindowDefine, this.operations);
        if (!CollectionUtils.isEmpty(this.openWindowConfigList)) {
            OpenWindowConfig openWindowConfig = this.openWindowConfigList.get(0);
            if (this.openWindowConfigList.size() == 1) {
                // 开窗配置一个时，条件默认为true
                openWindowConfig.setCondition("true");
            }
            this.selectDetailList = openWindowConfig.getSelectDetailList();
            this.selectIdList = openWindowConfig.getSelectIdList();
            this.rawData = openWindowConfig.getRawData();
            this.useHasNext = openWindowConfig.getUseHasNext();
            this.pageSize = openWindowConfig.getPageSize();
        }
        // clear
        this.openWindowDefine = null;
        this.operations = null;

        specialHandle(executeContext, schema);

        //提示语给默认值
        if (ObjectUtils.isEmpty(this.placeholder)) {
            this.placeholder = localeService.getLanguageValue(executeContext.getLocale(), "请选择");
        }
    }

    private void specialHandle(PcUiBotExecuteContext executeContext, String schema) {
        // 问题评审反馈通知人选用选人样式
        if ("questionIdentify".equalsIgnoreCase(executeContext.getTmActivityId())) {
            if ("identify_notice_person_info".equals(schema)) {
                this.selectType = 1;
            }
        }
    }

    private List<OpenWindowConfig>
    buildOpenWindowConfigList(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                              PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData,
                              PcUiBotTmOperation openWindowDefine, List<PcUiBotTmOperation> operations) {
        List<OpenWindowConfig> openWindowConfigList = new ArrayList<>();
        List<PcUiBotTmOperation> tmOperations = this.buildTmOperations(openWindowDefine, operations);
        if (CollectionUtils.isEmpty(tmOperations)) {
            return openWindowConfigList;
        }
        TmPageOperationService tmPageOperationService = SpringContextHolder.getBean(TmPageOperationService.class);
        for (PcUiBotTmOperation tmOperation : tmOperations) {
            openWindowConfigList.add(
                    this.buildOpenWindowConfig(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData,
                            tmOperation, tmPageOperationService));
        }
        return openWindowConfigList;
    }

    private List<PcUiBotTmOperation> buildTmOperations(PcUiBotTmOperation openWindowDefine, List<PcUiBotTmOperation> operations) {
        // 先取列表数据配置，如果存在直接返回，否则取明细配置
        if (!CollectionUtils.isEmpty(operations)) {
            operations.forEach(operation -> operation.setOperate("openwindow"));
            return operations;
        }
        if (openWindowDefine == null) {
            return new ArrayList<>();
        }
        PcUiBotTmOperation tmOperation = new PcUiBotTmOperation();
        tmOperation.setOperate("openwindow");
        tmOperation.setOpenWindowDefine(openWindowDefine.getOpenWindowDefine());
        return Lists.newArrayList(tmOperation);
    }

    private OpenWindowConfig
    buildOpenWindowConfig(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                          PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData,
                          PcUiBotTmOperation tmOperation, TmPageOperationService tmPageOperationService) {
        PcUiBotOperationDTO operationDTO = new PcUiBotOperationDTO();
        tmPageOperationService.parseOpenWindow(executeContext, false, tmOperation, operationDTO);
        PcUiBotOpenWindowDefineDTO openWindowDefine = operationDTO.getOpenWindowDefine();

        OpenWindowConfig openWindowConfig = new OpenWindowConfig().setName(openWindowDefine.getTitle()).setCondition(operationDTO.getOpenWindowConditional());
        if (openWindowDefine.getAllAction() == null) {
            return openWindowConfig;
        }

        Map<String, Object> rawData = new HashMap<>();
        // rawdata中存入代理token，此值在拦截器中处理
        rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
        rawData.put("dataSourceSet", openWindowDefine.getAllAction().getDataSourceSet());
        rawData.put("dataKeys", openWindowDefine.getAllAction().getDataSourceSet().getDataKeys());
        rawData.put("defaultShow", openWindowDefine.getAllAction().isDefaultShow());
        rawData.put("executeContext", openWindowDefine.getAllAction().getExecuteContext());
        rawData.put("multipleSelect", openWindowDefine.getMultipleSelect());
        rawData.put("selectedFirstRow", openWindowDefine.getSelectedFirstRow());
        rawData.put("queryTagSuffix", "DIALOG");
        rawData.put("pageInfo", openWindowDefine.getAllAction().getPageInfo());
        rawData.put("roleAttention", openWindowDefine.getRoleAttention());
        rawData.put("drilDownButton", InputWindowSingleSelect.buildDrilDownButton(openWindowDefine.getMobileDrilDown(), cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData));
        rawData.put("mobileSortInfo", openWindowDefine.getMobileSortInfo());
        // wjw FIXME: 2023/11/8 开窗页面构建时需要schema，根据schema获取mock数据或试验优测定制根据schema处理相关逻辑
        rawData.put("schema", schema);
        rawData.put("useHasNext", Optional.ofNullable(openWindowDefine.getUseHasNext()).orElse(false));
        rawData.put("buttons", openWindowDefine.getButtons());
        rawData.put("parameter", data);

        // 构建默认选中的数据
        this.buildDefaultSelect(openWindowConfig, data, mobilePath, schema, openWindowDefine.getAllAction().getDataSourceSet().getDataKeys(), openWindowDefine.getButtons());
        openWindowConfig.setRawData(rawData)
                .setUseHasNext(Optional.ofNullable(openWindowDefine.getUseHasNext()).orElse(false))
                .setPageSize(50);
        return openWindowConfig;
    }

    private void buildDefaultSelect(OpenWindowConfig openWindowConfig, Map<String, Object> data, String mobilePath, String schema,
                                    List<String> dataKeys, List<PcUiBotOpenWindowDefineButtonDTO> buttons) {
        Object o = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (o == null) {
            return;
        }
        if (!(o instanceof List)) {
            return;
        }
        openWindowConfig.setSelectDetailList((List<Object>) o);
        List<Map<String, Object>> list = (List<Map<String, Object>>) o;

        if (CollectionUtils.isEmpty(dataKeys)) {
            return;
        }
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        Map<String, String> backFills = BackFillsParseUtil.getBackFillMap(JsonUtil.objectToJavaObject(buttons, new TypeReference<List<Map<String, Object>>>() {
        }));
        if (backFills.isEmpty()) {
            return;
        }
        List<String> selectIds = new ArrayList<>(list.size());
        for (Map<String, Object> item : list) {
            StringBuilder sb = new StringBuilder();
            dataKeys.forEach(dataKey -> sb.append(StringUtil.valueOf(item.get(backFills.get(dataKey)))).append(PcUiBotConstants.WINDOW_ID_SEPERATOR));
            selectIds.add(sb.substring(0, sb.length() - PcUiBotConstants.WINDOW_ID_SEPERATOR.length()).trim());
        }
        openWindowConfig.setSelectIdList(selectIds);
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setComponentId(rawContent.getComponentId());
        inputWindowMultiSelect.setTitle(rawContent.getLabel());
        inputWindowMultiSelect.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.OpenWindowSelectObj openWindowSelectObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.OpenWindowSelectObj.class);
        if (openWindowSelectObj != null) {
            inputWindowMultiSelect.setPlaceholder(openWindowSelectObj.getPlaceholder());
            inputWindowMultiSelect.setIsEdit(openWindowSelectObj.getIsEdit());
            inputWindowMultiSelect.setStyle(openWindowSelectObj.getStyle());
            inputWindowMultiSelect.setOperations(openWindowSelectObj.getOperations());
        }
        if (!CollectionUtils.isEmpty(rawContent.getSubContent())) {
            // 设置拼接的字段
            Card.DesignerRawCard.Content subContent = rawContent.getSubContent().get(0);
            String displayValue = Card.getDisplayValue(subContent, StringUtil.valueOf(data.get(subContent.getSchema())));
            inputWindowMultiSelect.setSuffixText(displayValue);
        }
        inputWindowMultiSelect.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputWindowMultiSelect;
    }
}
