package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author zhangjj
 * @date 2021/11/4 0004 16:08
 */
@Component("inputWindowMultiSelectParamAnalyzer")
public class InputWindowMultiSelectParamAnalyzer implements ComponentParamAnalyzer<InputWindowMultiSelect, List<Object>> {
    private Logger logger = LoggerFactory.getLogger(InputWindowMultiSelectParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return InputWindowMultiSelect.COMPONENT_TYPE;
    }

    @Override
    public Class<InputWindowMultiSelect> getSubmitParamType() {
        return InputWindowMultiSelect.class;
    }

    @Override
    public List<Object> analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputWindowMultiSelect)) {
            logger.debug("submitParam is not instanceof InputWindowMultiSelect component..."
                    + "The data of it is: {}", JsonUtil.javaObjectToJsonString(submitParam));
            return new ArrayList<>();
        }
        InputWindowMultiSelect multiSelect = (InputWindowMultiSelect) submitParam;
        return Optional.ofNullable(multiSelect.getSelectDetailList()).orElse(new ArrayList<>());
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {

    }
}
