package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 开窗单选组件开窗item封装
 *
 * @author zhangjj
 * @date 2021/7/30 0030 14:29
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class InputWindowSingleItem extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 8402156939825315257L;
    public static final String COMPONENT_TYPE = "WINDOW_SINGLE_SELECT_ITEM";

    @Override
    public String returnComponentType() {
        return InputWindowSingleItem.COMPONENT_TYPE;
    }

    private String id;
    private String title;
    private InputWindowSingleItemLabel titleLabel;
    private String text;
    private String subtitle;
    private String image;
    private List<String> content;
    private List<SmartPreciseSearchField> dataList;

    private Boolean showImage;
    /**
     * 查看单个条目详情的按钮
     */
    private Button seeMoreButton;
    /**
     * 是否可编辑
     */
    private Boolean showEdit;
    /**
     * 编辑的action
     */
    private Action editAction;
    /**
     * 编辑的按钮
     */
    private Integer editIconData;
    /**
     * 原始数据
     */
    private Map<String, Object> detail;

    /**
     * 选中后触发的联动
     */
    private RelationRule relationRule;
    /**
     * 点击数据列表中的完成跳转到后端统一提交接口
     */
    private Action submitAction;

    public List<String> getContent() {
        if (null == content) {
            content = new ArrayList<>();
        }
        return content;
    }

    public Boolean getShowImage() {
        if (null == showImage) {
            showImage = false;
        }
        return showImage;
    }


    public Boolean getShowEdit() {
        if (showEdit == null) {
            showEdit = false;
        }
        return showEdit;
    }
}
