package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinition;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.list.card.OrderOptionEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.text.Collator;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InputWindowSingleSelectBuilder
 * @Author: Zaregoto
 * @Date: 2021/8/18 18:06
 */
@Component("inputWindowSingleItemBuilder")
public class InputWindowSingleItemBuilder implements MobileComponentListBuilder<InputWindowSingleItem> {

    private static final Logger logger = LoggerFactory.getLogger(InputWindowSingleItemBuilder.class);

    @Autowired
    private ColumnTagService columnTagService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public String getMobileComponentType() {
        return InputWindowSingleItem.COMPONENT_TYPE;
    }

    @Override
    public List<InputWindowSingleItem> build(ApiRequest apiRequest, PageSetting pageSetting,
                                             UiBotModel pcUiBotModel, Class<InputWindowSingleItem> clazz, Object... args) {
        List<UiBotLayout> uiBotLayouts = pcUiBotModel.getLayout();
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        String mTagId = getTagId(executeContext);
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }
        // 找到实际明细数据的layout
        Optional<UiBotLayout> optPcDataLayout = pcUiBotModel.getLayout()
                .stream()
                .filter(l -> l.getId() != null && l.getId().equalsIgnoreCase(l.getSchema()))
                .findFirst();
        if (!optPcDataLayout.isPresent()) {
            return Collections.emptyList();
        }

        UiBotLayout pcDataLayout = optPcDataLayout.get();
        if (!"TABLE".equalsIgnoreCase(pcDataLayout.getType())
                && !"ATHENA_TABLE".equalsIgnoreCase(pcDataLayout.getType())
                && !"GRID_TABLE".equalsIgnoreCase(pcDataLayout.getType())) {
            return Collections.emptyList();
        }

        String schema = pcDataLayout.getSchema();
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>>
                bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizDataList, "pagedata." + schema + " cannot be null");
        if (bizDataList.isEmpty()) {
            return Collections.emptyList();
        }

        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        // 分解出明细数据行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition
                .decomposeTableColumnDefinitions(tableColumnDefinitionList);
        List<ColumnTag> columnTagList;

        // 手动发起项目：智慧检料 根据tagId获取页面展示字段
        if (StrUtil.isNotEmpty(mTagId) && ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_TM_ACTIVITY_ID.equals(mTagId)) {
            columnTagList = this.columnTagService.listColumnTagsBymTagId(mTagId);
            return this.getItemListByBizDataAndColumnTag(schema, tableColumns, bizDataList, columnTagList, apiRequest, Collections.emptyMap());
        }

        if (StringUtils.hasLength(apiRequest.getPageId()) && ("ZtbReceiptScheduleChange".equals(apiRequest.getLinkSchema())
                || "MOBILE_PROJECT_CREATE".equalsIgnoreCase(apiRequest.getPageId())
                || "MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL".equalsIgnoreCase(apiRequest.getPageId()))) {
            columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(schema, apiRequest.getPageId());
        } else {
            columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        }
        if (CollectionUtils.isEmpty(columnTagList)) {
            columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        }

        return this.getItemListByBizDataAndColumnTag(schema, tableColumns, bizDataList, columnTagList, apiRequest, Collections.emptyMap());
    }

    /**
     * 根据条件获取tagId
     *
     * @param executeContext
     * @return
     */
    private static String getTagId(UiBotExecuteContext executeContext) {
        String mTagId = String.valueOf(executeContext.get("tmActivityId"));
        if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_TM_ACTIVITY_ID.equals(mTagId)) {
            return mTagId;
        }

        return mTagId;
    }


    private List<InputWindowSingleItem> getItemListByBizDataAndColumnTag(String path,
                                                                         List<UiBotTableColumn> tableColumns,
                                                                         List<Map<String, Object>> bizDataList, List<ColumnTag> columnTagList, ApiRequest apiRequest, Map<String, Object> extendParam) {
        List<InputWindowSingleItem> itemList = new ArrayList<>();

        Map<String, UiBotTableColumn> tableColumnMap =
                tableColumns.stream().collect(Collectors.toMap(UiBotTableColumn::getSchema, c -> c, (c1, c2) -> c1));

        // 查询数据字典，获取值和映射值的对应关系
        Map<String, Map<String, String>> translateShowValueMap = getTranslateShowValueMap(tableColumns, columnTagList, apiRequest);

        // 业务数据ID的tag
        List<ColumnTag> bizIdTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.BUSINESS_ID.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());

        // 标题字段tag
        List<ColumnTag> titleTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());

        // 副标题字段tag
        List<ColumnTag> subtitleTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_SUBTITLE.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());

        // 次要字段tag
        List<ColumnTag> profileTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());

        bizDataList.forEach(bizData -> {
            InputWindowSingleItem item = new InputWindowSingleItem();
            String id = this.getBusinessDataId(bizData, bizIdTagList);
            item.setId(StringUtil.isEmpty(id) ? this.getDisplayTitle(bizData, titleTagList) : id);
            item.setTitle(this.getDisplayTitle(bizData, titleTagList));
            item.setSubtitle(this.getDisplaySubtitle(bizData, subtitleTagList));
            item.setShowImage(false);
            item.setContent(this.getDisplayProfile(bizData, profileTagList, tableColumnMap, translateShowValueMap, extendParam));
            //多选时需要提交整个数据
            item.setDetail(bizData);
            item.setSeeMoreButton(this.buildSeeMoreButton(apiRequest, bizData));
            // add by mowj 20210819
            // 为了用户看到的数据展示结果没问题，当数据本身有问题时做一个特殊处理：
            // 如果没有title，但有subtitle，将subtitle的值给title做显示。
            if (item.getTitle().isEmpty() && !item.getSubtitle().isEmpty()) {
                item.setTitle(item.getSubtitle());
            }
            if (StringUtil.isNotEmpty(item.getId())) {
                itemList.add(item);
            }
        });

        return itemList;
    }

    private Button<UiBotAction> buildSeeMoreButton(ApiRequest apiRequest, Map<String, Object> bizData) {
        Map<String, Object> apiRequestRawData = apiRequest.getRawData().getInnerMap();
        Object drilDownButton = apiRequestRawData.get("drilDownButton");
        Button<UiBotAction> seeMoreButton = JsonUtil.objectToJavaObject(drilDownButton, new TypeReference<Button<UiBotAction>>() {
        });
        if (seeMoreButton == null) {
            return null;
        }
        Action action = seeMoreButton.getAction();
        if (action == null) {
            return null;
        }
        // 无rawdata，则不展示按钮
        Map<String, Object> rawData = (Map<String, Object>) action.getRawData();
        if (rawData == null) {
            return null;
        }
        Object data = rawData.get("data");
        if (Objects.nonNull(data) && data instanceof Map) {
            Map<String, Object> dataMap = (Map<String, Object>) data;
            if (Objects.nonNull(apiRequestRawData.get("parameter"))) {
                Map<String, Object> parameter = (Map<String, Object>) apiRequestRawData.get("parameter");
                dataMap.putAll(parameter);
            }
            dataMap.putAll(bizData);
            rawData.put("data", dataMap);
        } else {
            rawData.put("data", bizData);
        }
        return seeMoreButton;
    }

    private Map<String, Map<String, String>> getTranslateShowValueMap(List<UiBotTableColumn> tableColumns, List<ColumnTag> columnTagList, ApiRequest apiRequest) {
        List<String> columnTagSchemaList = columnTagList.stream().map(ColumnTag::getSchema).collect(Collectors.toList());
        List<UiBotTableColumn> enumKeyIsNotEmptyuiBotTableColumnSet = tableColumns.stream()
                .filter(e -> columnTagSchemaList.contains(e.getSchema()) && StringUtils.hasLength(e.getEnumKey()))
                .collect(Collectors.toList());

        Map<String, Map<String, String>> translateShowValueMap = new HashMap<>();
        for (UiBotTableColumn enumKeyIsNotEmptyuiBotTableColumn : enumKeyIsNotEmptyuiBotTableColumnSet) {
            List<Map<String, Object>> dictByKeyList = null;
            try {
                dictByKeyList = digiwinKnowledgeMapsProxyService.getDictByKey(apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), enumKeyIsNotEmptyuiBotTableColumn.getEnumKey());
            } catch (Exception e) {
                logger.error("InputWindowSingleItemBuilder getTranslateShowValueMap error:", e);
                continue;
            }

            if (CollectionUtils.isEmpty(dictByKeyList)) {
                continue;
            }
            Map<String, String> dictMapByKey = dictByKeyList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("code")),
                    e -> String.valueOf(e.get("value")), (c1, c2) -> c1));
            translateShowValueMap.put(enumKeyIsNotEmptyuiBotTableColumn.getSchema(), dictMapByKey);
        }
        return translateShowValueMap;
    }

    private String getBusinessDataId(Map<String, Object> bizData, List<ColumnTag> bizIdColumnTagList) {
        boolean tagCodeCorrect = bizIdColumnTagList.stream()
                .allMatch(columnTag -> columnTag.getTagDefinition().getCode()
                        .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.BUSINESS_ID.getCode()));
        if (!tagCodeCorrect) {
            return "";
        }
        StringBuffer resultSb = new StringBuffer();
        int separatorLength = 0;
        for (ColumnTag columnTag : bizIdColumnTagList) {
            String schema = columnTag.getSchema();
            separatorLength = Optional.ofNullable(columnTag.getSeparator()).map(String::length).orElse(0);
            resultSb
                    .append(Optional.ofNullable(bizData.get(schema)).orElse(""))
                    .append(Optional.ofNullable(columnTag.getSeparator()).orElse(ColumnTag.DEFAULT_BUSINESS_SEPERATOR));
        }

        if (resultSb.length() > 0) {
            return resultSb.substring(0, resultSb.length() - separatorLength).trim();
        }
        return "";
    }

    private String getDisplayTitle(Map<String, Object> bizData, List<ColumnTag> titleColumnTagList) {
        boolean tagCodeCorrect = titleColumnTagList.stream()
                .allMatch(columnTag -> columnTag.getTagDefinition().getCode()
                        .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()));
        if (!tagCodeCorrect) {
            return "";
        }
        StringBuffer resultSb = new StringBuffer();
        int separatorLength = 0;
        for (ColumnTag columnTag : titleColumnTagList) {
            String schema = columnTag.getSchema();
            separatorLength = Optional.ofNullable(columnTag.getSeparator()).map(String::length).orElse(0);
            resultSb
                    .append(Optional.ofNullable(bizData.get(schema)).orElse(""))
                    .append(Optional.ofNullable(columnTag.getSeparator()).orElse(ColumnTag.DEFAULT_DISPLAY_SEPERATOR));
        }

        if (resultSb.length() > 0) {
            return resultSb.substring(0, resultSb.length() - separatorLength).trim();
        }
        return "";
    }

    private String getDisplaySubtitle(Map<String, Object> bizData, List<ColumnTag> subtitleColumnTagList) {
        boolean tagCodeCorrect = subtitleColumnTagList.stream()
                .allMatch(columnTag -> columnTag.getTagDefinition().getCode()
                        .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_SUBTITLE.getCode()));
        if (!tagCodeCorrect) {
            return "";
        }
        StringBuffer resultSb = new StringBuffer();
        int separatorLength = 0;
        for (ColumnTag columnTag : subtitleColumnTagList) {
            String schema = columnTag.getSchema();
            separatorLength = Optional.ofNullable(columnTag.getSeparator()).map(String::length).orElse(0);
            resultSb
                    .append(Optional.ofNullable(bizData.get(schema)).orElse(""))
                    .append(Optional.ofNullable(columnTag.getSeparator()).orElse(ColumnTag.DEFAULT_DISPLAY_SEPERATOR));
        }
        if (resultSb.length() > 0) {
            return resultSb.substring(0, resultSb.length() - separatorLength).trim();
        }
        return "";
    }

    private List<String> getDisplayProfile(Map<String, Object> bizData, List<ColumnTag> profileColumnTagList,
                                           Map<String, UiBotTableColumn> tableColumnMap, Map<String, Map<String, String>> translateShowValueMap,
                                           Map<String, Object> extendParam) {
        boolean tagCodeCorrect = profileColumnTagList.stream()
                .allMatch(columnTag -> columnTag.getTagDefinition().getCode()
                        .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()));
        if (!tagCodeCorrect) {
            return Collections.emptyList();
        }

        Boolean isDesigner = (Boolean) MapUtil.getOrDefault(extendParam, "isDesigner", false);
        List<String> result = new ArrayList<>();
        profileColumnTagList.forEach(columnTag -> {
            String schema = columnTag.getSchema();
            if (tableColumnMap.get(schema) != null
                    && StringUtil.isNotEmpty(Optional.ofNullable(bizData.get(schema)).map(Object::toString).orElse(""))) {

                String bizDataBySchema = String.valueOf(bizData.get(schema));
                if (BooleanUtils.isTrue(isDesigner)) {
                    // 数据展示成对应映射值，如状态字段数据值为10，对应已完成，转化为展示已完成
                    if (translateShowValueMap.containsKey(schema)) {
                        bizDataBySchema = translateShowValueMap.get(schema).get(bizDataBySchema);
                        if (!StringUtils.hasLength(bizDataBySchema)) {
                            bizDataBySchema = "-";
                        }
                    }
                }
                String content = tableColumnMap.get(schema).getHeaderName()
                        + ColumnTag.DEFAULT_DISPLAY_SEPERATOR
                        + bizDataBySchema;
                result.add(content.trim());
            }
        });

        return result;
    }

    private void translate() {

    }

    /**
     * 若所有DataSourceDTO都没有配置ActionParams，则清空Parameter
     *
     * @param rawData
     */
    private void getPageDefineParameter(ApiRawData rawData) {
        if (rawData.get("dataSourceSet") == null) {
            return;
        }
        if (rawData.getJSONObject("dataSourceSet").get("dataSourceList") == null) {
            return;
        }
        boolean isCheckEmpty = true;
        JSONArray jsonArray = rawData.getJSONObject("dataSourceSet").getJSONArray("dataSourceList");
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject dataSourceDTO = jsonArray.getJSONObject(i);
            if (dataSourceDTO.get("action") != null
                    && !CollectionUtils.isEmpty(dataSourceDTO.getJSONObject("action").getJSONArray("actionParams"))) {
                isCheckEmpty = false;
            }
        }
        if (isCheckEmpty) {
            rawData.put("parameter", null);
        }
    }

    private void parseActiveParentRowTypeParameter(ApiRawData rawData) {

        if (rawData.get("dataSourceSet") == null) {
            return;
        }
        JSONArray dataSourceList = rawData.getJSONObject("dataSourceSet").getJSONArray("dataSourceList");
        if (CollectionUtils.isEmpty(dataSourceList)) {
            return;
        }
        this.transParentParameter(dataSourceList, (Map<String, Object>) rawData.get("parameter"));
    }

    private void transParentParameter(JSONArray dataSourceList, Map<String, Object> parameter) {
        for (int i = 0; i < dataSourceList.size(); i++) {
            JSONObject dataSourceDTO = dataSourceList.getJSONObject(i);
            if (!PcUiBotActivityConstants.ActionParamType.ACTIVE_PARENT_ROW.equals(dataSourceDTO.get("parameterType"))
                    || null == dataSourceDTO.get("action")
                    || CollectionUtils.isEmpty(dataSourceDTO.getJSONObject("action").getJSONArray("actionParams"))) {
                continue;
            }
            JSONArray actionParams = dataSourceDTO.getJSONObject("action").getJSONArray("actionParams");
            // 平铺请求参数
            Map<String, Object> parameterMapping = flatParameter(parameter);
            // 将type=ACTIVE_PARENT_ROW 的参数，解析出实际值并替换actionParam.value后，再将type值修改为ACTIVE_ROW_CONSTANT
            for (int j = 0; j < actionParams.size(); j++) {
                JSONObject actionParameter = actionParams.getJSONObject(j);
                if (PcUiBotActivityConstants.ActionParamType.ACTIVE_PARENT_ROW.equals(actionParameter.getString("type"))) {
                    Object paramValue = parameterMapping.get(actionParameter.getString("value"));
                    // ACTIVE_PARENT_ROW 转变为 ACTIVE_ROW_CONSTANT
                    actionParameter.put("type", PcUiBotActivityConstants.ActionParamType.ACTIVE_ROW_CONSTANT);
                    actionParameter.put("value", null != paramValue ? String.valueOf(paramValue) : null);
                }
            }
        }
    }

    private Map<String, Object> flatParameter(Map<String, Object> parameter) {
        /**
         * {
         * 	"account_conversion_detail_info": {
         * 		"account_std_no1": "101",
         * 		"account_std_name1": "大陸科目參照表",
         * 		"account_conversion_detail": [
         *                        {
         * 				"primary_key": 469,
         * 				"account_std_no1": "101",
         * 				"account_std_name1": "大陸科目參照表"
         *            }
         * 		]
         *    }
         * }
         *
         * 平铺结果：
         * {
         *  "account_conversion_detail_info": {...},
         * 	"account_conversion_detail_info.account_std_no1": "101",
         * 	"account_conversion_detail_info.account_std_name1": "大陸科目參照表",
         * 	"account_conversion_detail_info.account_conversion_detail.primary_key": 469,
         * 	"account_conversion_detail_info.account_conversion_detail": {...},
         * 	"account_conversion_detail_info.account_conversion_detail.account_std_no1": "101",
         * 	"account_conversion_detail_info.account_conversion_detail.account_std_name1": "大陸科目參照表"
         * }
         */
        Map<String, Object> parameterMapping = new HashMap<>();
        if (!CollectionUtils.isEmpty(parameter)) {
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                parameterMapping.putAll(flatParameterHelp(entry.getKey(), entry.getValue(), 1));
            }
        }

        return parameterMapping;
    }

    private Map<String, Object> flatParameterHelp(String key, Object value, int recursionDepth) {
        Map<String, Object> parameterMapping = new HashMap<>();
        parameterMapping.put(key, value);
        // 递归解析深度最大为3
        if (null == value || recursionDepth >= 3) {
            return parameterMapping;
        } else if (value instanceof List) {
            // 对于集合，取第一个元素进行递归平铺
            if (!CollectionUtils.isEmpty((List) value)) {
                Object firstElement = ((List) value).get(0);
                parameterMapping.putAll(flatParameterHelp(key, firstElement, recursionDepth));
            }
        } else if (value instanceof Map) {
            // 对Map中每个key-value递归平铺
            Map<String, Object> map = (Map<String, Object>) value;
            if (!CollectionUtils.isEmpty(map)) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    int tmpRecursionDepth = recursionDepth;
                    parameterMapping.putAll(flatParameterHelp(key + "." + entry.getKey(), entry.getValue(), ++tmpRecursionDepth));
                }
            }
        }

        return parameterMapping;
    }

    public InputWindowSingleResponseData buildInputWindowData(ApiRequest apiRequest) {
        InputWindowSingleResponseData responseData = InputWindowSingleResponseData.empty();

        // 是否开启分页
        Boolean useHasNext = apiRequest.getRawData().getBoolean("useHasNext");
        if (BooleanUtils.isTrue(useHasNext)) {
            this.getPageDefineParameter(apiRequest.getRawData());

            this.parseActiveParentRowTypeParameter(apiRequest.getRawData());
        }

        // 查询元数据
        QueryResultSet queryResultSet = digiwinAtdmProxyService
                .queryWithMetaData(
                        apiRequest.getLocale(),
                        apiRequest.getIamUserToken(),
                        JsonUtil.javaObjectToJsonString(apiRequest.getRawData()),
                        apiRequest.getTenantId());
        // 合并开窗数据
        merageOpenwindowData(queryResultSet);
        if (queryResultSet == null
                || queryResultSet.getMainQueryResult() == null) {
            return responseData;
        }
        List<InputWindowSingleItem> itemList = this.buildWindowItem(apiRequest, queryResultSet);
        if (CollectionUtils.isEmpty(itemList)) {
            return responseData;
        }
        responseData.setSearchType(BooleanUtils.isTrue(useHasNext) ?
                InputWindowSingleSelectSearchTypeEnum.BACKEND_SEARCH.getType() :
                InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
        responseData.setList(itemList);
        responseData.setTotal(itemList.size());
        return responseData;
    }

    public List<InputWindowSingleItem> buildWindowItem(ApiRequest apiRequest, QueryResultSet queryResultSet) {
        ApiRawData rawData = apiRequest.getRawData();

        // 获取数据源名称
        String dataSourceName = queryResultSet.getMainQueryResult().getDataSourceName();
        // 构建显示字段
        List<ColumnTag> columnTagList = this.buildDisplayField(dataSourceName,
                (List<String>) rawData.get("roleAttention"), (List<String>) rawData.get("dataKeys"));
        // 获取查询结果数据
        List<Map<String, Object>> bizDataList = this.getQueryResultData(rawData,
                (List<Map<String, Object>>) queryResultSet.getPageData().get(dataSourceName));
        // wjw TODO: 2024/11/19 对结果进行排序
        this.handleDataSort(rawData, bizDataList);
        // 获取开窗数据列
        List<UiBotTableColumn> tableColumns = this.createShowMetadataColumn(queryResultSet.getMainQueryResult()
                .getApiMetadataCollection().getMasterApiMetadata());

        Map<String, Object> extendParam = new HashMap<>();
        extendParam.put("isDesigner", true);
        return this.getItemListByBizDataAndColumnTag(dataSourceName, tableColumns, bizDataList, columnTagList, apiRequest, extendParam);
    }

    private void handleDataSort(ApiRawData rawData, List<Map<String, Object>> bizDataList) {
        if (CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        // 是否开启分页
        Boolean useHasNext = rawData.getBoolean("useHasNext");
        if (BooleanUtils.isTrue(useHasNext)) {
            return;
        }
        // 不分页情况下，则对结果进行排序
        List<PcUiBotTmOperationOpenWindowDefine.SortInfo> mobileSortInfo = JsonUtil.objectToJavaObject(rawData.get("mobileSortInfo"), new TypeReference<List<PcUiBotTmOperationOpenWindowDefine.SortInfo>>() {
        });
        if (CollectionUtils.isEmpty(mobileSortInfo)) {
            return;
        }
        // 排序
        List<Map<String, Object>> collect = bizDataList.stream().sorted((o1, o2) -> {
                    for (PcUiBotTmOperationOpenWindowDefine.SortInfo sortInfo : mobileSortInfo) {
                        int result;
                        String sortField = sortInfo.getSortField();
                        String dataType = sortInfo.getDataType();
                        Object value1 = o1.get(sortField);
                        Object value2 = o2.get(sortField);
                        // 这里可以根据具体类型进行比较，例如 String，Integer 等
                        if ("string".equals(dataType)) {
                            Collator collator;
                            if ("zh_CN".equalsIgnoreCase(AppRequestContext.getContextEntity().getLocale())) {
                                collator = Collator.getInstance(Locale.SIMPLIFIED_CHINESE);
                            } else {
                                collator = Collator.getInstance(Locale.TRADITIONAL_CHINESE);
                            }
                            result = collator.compare(value1, value2);
                        } else if ("number".equals(dataType)) {
                            // 确保安全地转换为整数
                            int num1 = value1 instanceof Number ? ((Number) value1).intValue() : 0;
                            int num2 = value2 instanceof Number ? ((Number) value2).intValue() : 0;
                            result = Integer.compare(num1, num2);
                        } else {
                            result = 0;
                        }
                        // 根据 sortInfo 的排序方向决定返回值
                        if (result != 0) {
                            return OrderOptionEnum.ASC.getType().equals(sortInfo.getSortType()) ? result : -result;
                        }
                    }
                    // 如果所有字段比较结果都相等
                    return 0;
                }
        ).collect(Collectors.toList());
        bizDataList.clear();
        bizDataList.addAll(collect);
    }

    private List<Map<String, Object>> getQueryResultData(ApiRawData rawData, List<Map<String, Object>> bizDataList) {
        if (CollectionUtils.isEmpty(bizDataList)) {
            return new ArrayList<>();
        }

        String actionId = "";
        PcUiBotDataSourceSetDTO pcUiBotDataSourceSetDTO = JsonUtil.objectToJavaObject(rawData.get("dataSourceSet"), PcUiBotDataSourceSetDTO.class);
        List<PcUiBotDataSourceDTO> pcUiBotDataSourceDTOList = Optional.ofNullable(pcUiBotDataSourceSetDTO)
                .map(PcUiBotDataSourceSetDTO::getDataSourceList).orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(pcUiBotDataSourceDTOList)) {
            actionId = pcUiBotDataSourceDTOList.get(0).getActionId();
        }

        if ("total_judgment_level".equals(rawData.getString("schema"))) {
            // 试验优测定制-综合判定等级开窗
            bizDataList = Optional
                    .ofNullable((List<Map<String, Object>>) bizDataList.get(0).get("judgment_header_list"))
                    .orElse(new ArrayList<>())
                    .stream()
                    .filter(r -> "1".equals(StringUtil.valueOf(r.get("judgment_type"))))
                    .collect(Collectors.toList());
        }

        if ("esp_question.eoc.dept.user.info.get".equalsIgnoreCase(actionId)) {
            bizDataList = bizDataList.stream().map(e -> {
                List<Map<String, Object>> employeeInfoListByDepartment = (List<Map<String, Object>>) MapUtil.getOrDefault(e, "employee_info", Collections.emptyList());
                employeeInfoListByDepartment.forEach(item -> {
                    item.put("department_id", e.get("department_id"));
                    item.put("department_name", e.get("department_name"));
                });
                return employeeInfoListByDepartment;
            }).flatMap(List::stream).collect(Collectors.toList());
        }
        return bizDataList;
    }

    private List<ColumnTag> buildDisplayField(String dataSourceName, List<String> roleAttention, List<String> dataKeys) {
        List<ColumnTag> columnTagList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(roleAttention)) {
            for (int i = 0; i < roleAttention.size(); i++) {
                ColumnTag columnTag = new ColumnTag().setPath(dataSourceName).setSchema(roleAttention.get(i)).setOrderNo(i);
                columnTagList.add(columnTag);
                ColumnTagDefinition tagDefinition = new ColumnTagDefinition();
                columnTag.setTagDefinition(tagDefinition);
                if (i == 0) {
                    tagDefinition.setCode(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode());
                } else {
                    tagDefinition.setCode(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode());
                }
            }
        }
        if (!CollectionUtils.isEmpty(dataKeys)) {
            for (int i = 0; i < dataKeys.size(); i++) {
                ColumnTag columnTag = new ColumnTag().setPath(dataSourceName).setSchema(dataKeys.get(i)).setOrderNo(i)
                        .setSeparator(PcUiBotConstants.WINDOW_ID_SEPERATOR);
                columnTagList.add(columnTag);
                ColumnTagDefinition tagDefinition = new ColumnTagDefinition();
                columnTag.setTagDefinition(tagDefinition);
                tagDefinition.setCode(ColumnTagDefinitionCodeEnum.BUSINESS_ID.getCode());
            }
        }

        return columnTagList;
    }

    private List<UiBotTableColumn> createShowMetadataColumn(PcUiBotApiMetadata masterApiMetadata) {
        List<PcUiBotMetadataField> subFields = masterApiMetadata.getResponseFields().get(0).getSubFields();
        return subFields.stream().map(r -> {
            UiBotTableColumn uiBotTableColumn = new UiBotTableColumn();
            uiBotTableColumn.setDataType(r.getDataType());
            uiBotTableColumn.setHeaderName(r.getDescription());
            uiBotTableColumn.setPath(r.getPath());
            uiBotTableColumn.setSchema(r.getName());
            uiBotTableColumn.setEnumKey(r.getEnumKey());
            return uiBotTableColumn;
        }).collect(Collectors.toList());
    }

    private void merageOpenwindowData(QueryResultSet queryResultSet) {
        if (queryResultSet != null
                && queryResultSet.contains("suggestActionName")) {
            //开窗逻辑改写：将推荐和全部数据合并成一个，同时增加一列返回给前端告之是否推荐
            Map<String, List<QueryResult>> group = queryResultSet.getQueryResults().stream().collect(Collectors.groupingBy(QueryResult::getDataSourceName));
            QueryResult queryResult_main = new QueryResult();
            //用于存放合并后的数据
            QueryResult queryResult = new QueryResult();
            if (group.size() > 1) {
                //经过前端合并之后，这里不可能出现DataSourceName相同的数据源数据；
                for (Map.Entry<String, List<QueryResult>> groupItem : group.entrySet()) {
                    List<QueryResult> resultList = groupItem.getValue();
                    if (!CollectionUtils.isEmpty(resultList)) {
                        for (QueryResult queryResult_tmp : resultList) {
                            //判断为全部的数据源 ,如果是全部取出主数据源
                            if ("allActionName".equals(queryResult_tmp.getDataSourceName())) {
                                //if (actionId.equals(queryResult_tmp.getApiMetadataCollection().getMasterApiMetadata().getActionId())) {
                                queryResult_tmp.getData().forEach(item -> item.put("recommend", false));
                                queryResult_main = queryResult_tmp;
                                if (queryResult.getData() != null) {
                                    queryResult_main.getData().removeAll(queryResult_tmp.getData());//NOSONAR
                                    queryResult_main.getData().addAll(0, queryResult.getData());

                                    queryResultSet.getQueryResults().remove(queryResult_tmp);
                                    queryResult = queryResult_main;
                                    queryResultSet.getQueryResults().add(queryResult_main);
                                } else {
                                    queryResult = queryResult_tmp;
                                }
                            }
                            //判断如果是推荐，recommend标记为true
                            else if ("suggestActionName".equals(queryResult_tmp.getDataSourceName())) {
                                queryResult_tmp.getData().forEach(item -> item.put("recommend", true));
                                if (queryResult.getData() != null) {
                                    //删除推荐的数据合并到全部中
                                    queryResultSet.getQueryResults().remove(queryResult_tmp);
                                    queryResult.getData().addAll(0, queryResult_tmp.getData());
                                    queryResult.getDataKeyIndex().putAll(queryResult_tmp.getDataKeyIndex());
                                } else {
                                    queryResult = queryResult_tmp;
                                    queryResultSet.getQueryResults().remove(queryResult_tmp);
                                }
                            }

                        }
                    }
                }
                //重新整理数据源和数据
                if (queryResult_main.getData() != null) {
                    if (!queryResult_main.getData().isEmpty() && queryResult_main.getData().get(0).get("__DATA_KEY") != null) {
                        //根据value字段值去重，保留第一次放入list的map值
//                        List<Map<String, Object>> listall = queryResult_main.getData().stream().collect(
//                                Collectors.collectingAndThen(
//                                        Collectors.toCollection(
//                                                () -> new TreeSet<>(Comparator.comparing(m -> m.containsKey("__DATA_KEY") ? m.get("__DATA_KEY").toString() : ""))
//                                        ), ArrayList::new));
//
//                        //重新排序
//                        listall.sort((firstMapEntry, secondMapEntry) -> {
//                            boolean tag1 = (Boolean) firstMapEntry.get("recommend");
//                            boolean tag2 = (Boolean) secondMapEntry.get("recommend");
//                            return (tag2 == true ? (tag1 == tag2 ? 0 : 1) : -1);
//                        });

                        //有序的最新结果存放，以API返回结果顺序为准
                        List<Map<String, Object>> listalls = new ArrayList<>();
                        //按API返回的顺序将数据拿出
                        List<Map<String, Object>> listallT = new ArrayList<>();
                        List<Map<String, Object>> listallF = new ArrayList<>();

                        queryResult_main.getData().forEach(data -> {
                            if (data.containsKey("recommend") && (Boolean) data.get("recommend")) {
                                listallT.add(data);
                            } else {
                                //以__DATA_KEY去重，当推荐中存在，就从all中拿掉
                                if (data.containsKey("__DATA_KEY")) {
                                    Optional<Map<String, Object>> optional = listallT.stream().filter(t -> t.containsKey("__DATA_KEY") && t.get("__DATA_KEY").equals(data.get("__DATA_KEY"))).findFirst();
                                    if (!optional.isPresent()) {
                                        listallF.add(data);
                                    }
                                }
                            }
                        });
                        listalls.addAll(listallT);
                        listalls.addAll(listallF);

                        //打印过滤后的数据
                        queryResult_main.resetData(listalls);
                        queryResultSet.setMainQueryResult(queryResult_main);
                    }
                }
            }
            if (group.size() == 1) {
                if ("suggestActionName".equals(queryResultSet.getMainQueryResult().getDataSourceName())) {
                    queryResultSet.getMainQueryResult().getData().forEach(item -> item.put("recommend", true));
                    if (queryResultSet.getQueryResults() != null && !queryResultSet.getQueryResults().isEmpty()) {
                        queryResultSet.getQueryResults().get(0).getData().forEach(item -> item.put("recommend", true));
                    }
                }
            }
        }
    }
}
