package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 开窗单选数据接口响应body封装
 *
 * @author zhangjj
 * @date 2021/7/30 0030 14:20
 */
@Data
public class InputWindowSingleResponseData implements Serializable {
    private static final long serialVersionUID = -3044076777367521498L;

    /**
     * 搜索方式；1：接口搜索；2：前端搜索。空值时按接口搜索
     */
    private Integer searchType;

    private Integer total;

    private List<InputWindowSingleItem> list;

    public InputWindowSingleResponseData() {
    }

    public static InputWindowSingleResponseData empty() {
        InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
        responseData.setList(new ArrayList<>());
        responseData.setTotal(0);
        responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
        return responseData;
    }
}
