package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.BackFillsParseUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineButtonDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * 开窗单选组件
 *
 * @author zhangjj
 * @date 2021/7/13 0013 17:21
 */
@Data
@Accessors(chain = true)
public class InputWindowSingleSelect extends BaseInputMobileComponent implements Serializable {
    private static final long serialVersionUID = 4409556361187206414L;
    public static final String COMPONENT_TYPE = "WINDOW_SINGLE_SELECT";

    @Override
    public String returnComponentType() {
        return InputWindowSingleSelect.COMPONENT_TYPE;
    }

    private String title;

    private InputWindowSingleItemLabel titleLabel;

    private String url;

    private String selectId;

    private Map<String, Object> selectDetail;

    /**
     * 默认选中的Id
     * 该项有值时，需渲染完组件后直接请求一次数据接口，填写默认显示值，以及相关联动操作。
     * 当此值为${CURRENT_ACCOUNT_ID}时，需将此值换为当前登陆人ID
     */
    private String defaultSelectId;
    /**
     * 回填数据中已有的值，该项不直接回填到开窗选项中(当defaultSelectId有值时，该值失效)
     */
    private String defaultShowValue;
    /**
     * 选中的详情信息
     */
    private Map<String, Object> detail;

    /**
     * 组件样式
     *
     * @see InputWindowSelectStyleEnum
     */
    private Integer style;
    private Integer styleType;

    private Map<String, Object> rawData;

    /**
     * 选择的类型，0代表文本，1代表人
     */
    private Integer selectType;

    private final String type = this.returnComponentType();

    /**
     * 是否为新组件
     */
    private Boolean isNew = false;
    /**
     * 数据列表内是否显示新增按钮
     */
    private Boolean showAddIcon = false;


    private Action addAction;

    private Integer addIconData;

    //是否有搜索,默认true
    private Boolean hasSearch = true;

    //是否仅展示,默认false
    private Boolean onlyShow = false;
    private String showValue;
    /**
     * 点击数据列表中的完成跳转到后端统一提交接口
     */
    private Action submitAction;

    /**
     * 开窗最大选择数量
     */
    private Integer maxSelectNum;

    /**
     * 是否支持手动输入
     */
    private Boolean isEdit = false;

    /**
     * 当isEdit = true时，默认都是支持模糊匹配
     * 是否支持模糊匹配
     */
    private Boolean isVagueSearch;

    /**
     * 模糊匹配只有主标题最多显示数量
     */
    private Integer maxTitleNum;

    /**
     * 模糊匹配有主标题和副标题最多显示数量
     */
    private Integer maxSubtitleNum;

    /**
     * 后缀文本
     */
    private String suffixText;

    public InputWindowSingleSelect() {
    }

    public void setType(String type) {
    }

    /**
     * 可编辑模糊匹配
     *
     * @param uiBotFieldLayout
     * @param required
     * @param enable
     * @param url
     * @param locale
     * @param executeContext
     * @param isEdit
     * @param isVagueSearch
     * @param maxTitleNum
     * @param maxSubtitleNum
     * @return
     */
    public static InputWindowSingleSelect create(UiBotLayout uiBotFieldLayout, Boolean required, Boolean enable
            , String url, String locale, UiBotExecuteContext executeContext, Boolean isEdit, Boolean isVagueSearch
            , Integer maxTitleNum, Integer maxSubtitleNum) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        if (uiBotFieldLayout != null) {
            windowSingleSelect.setSchema(uiBotFieldLayout.getSchema());
            windowSingleSelect.setTitle(uiBotFieldLayout.getHeaderName());
            windowSingleSelect.setRawData(uiBotFieldLayout.parseExecuteContextToRawData(uiBotFieldLayout, executeContext));
        }
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请输入选择"));
        windowSingleSelect.setRequired(required);
        windowSingleSelect.setEnable(enable);
        windowSingleSelect.setIsEdit(isEdit);
        windowSingleSelect.setIsVagueSearch(isVagueSearch);
        windowSingleSelect.setMaxTitleNum(maxTitleNum);
        windowSingleSelect.setMaxSubtitleNum(maxSubtitleNum);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotFieldLayout, Boolean required, Boolean enable, String url, String locale, UiBotExecuteContext executeContext) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        if (uiBotFieldLayout != null) {
            windowSingleSelect.setSchema(uiBotFieldLayout.getSchema());
            windowSingleSelect.setTitle(uiBotFieldLayout.getHeaderName());
            windowSingleSelect.setRawData(uiBotFieldLayout.parseExecuteContextToRawData(uiBotFieldLayout, executeContext));
        }
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(required);
        windowSingleSelect.setEnable(enable);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, String url, String locale, UiBotExecuteContext executeContext) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        if (uiBotFieldLayout != null) {
            windowSingleSelect.setSchema(uiBotFieldLayout.getSchema());
            windowSingleSelect.setTitle(uiBotFieldLayout.getHeaderName());
            windowSingleSelect.setRawData(uiBotFieldLayout.parseExecuteContextToRawData(uiBotFieldLayout, executeContext));
        }
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        if (uiBotRule != null) {
            windowSingleSelect.setRequired("required".equals(uiBotRule.getKey()));
        } else {
            windowSingleSelect.setRequired(false);
        }
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotFieldLayout, Boolean required,
                                                 String url, UiBotModel pcUiBotModel, Boolean enable,
                                                 Map<String, Object> bizData, ApiRequest request) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        if (uiBotFieldLayout != null) {
            windowSingleSelect.setSchema(uiBotFieldLayout.getSchema());
            windowSingleSelect.setTitle(uiBotFieldLayout.getHeaderName());
            Map<String, Object> rawData = new HashMap<>(8);
            if (uiBotFieldLayout.getOperations() != null && uiBotFieldLayout.getOperations().size() > 0) {
                JSONObject operation = uiBotFieldLayout.getOperations().getJSONObject(0);
                JSONObject openWindowDefine = operation.getJSONObject("openWindowDefine");
                if (openWindowDefine != null) {
                    List<UiBotTableColumnDefinition> columnDefs = uiBotFieldLayout.getColumnDefs();
                    if (columnDefs == null) {
                        windowSingleSelect.setTitle(openWindowDefine.getString("title"));
                    }
                }
                rawData.put("dataSourceSet",
                        operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("dataSourceSet"));
                rawData.put("defaultShow",
                        operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getBooleanValue("defaultShow"));
                JSONObject executeContextObj =
                        operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("executeContext");
                if (executeContextObj != null) {
                    rawData.put("executeContext", executeContextObj);
                } else {
                    rawData.put("executeContext", executeContext);
                }
                rawData.put("multipleSelect",
                        operation.getJSONObject("openWindowDefine").getBooleanValue("multipleSelect"));
                rawData.put("selectedFirstRow",
                        operation.getJSONObject("openWindowDefine").getBooleanValue("selectedFirstRow"));
                rawData.put("queryTagSuffix", "DIALOG");
                rawData.put("buttons",
                        operation.getJSONObject("openWindowDefine").getJSONArray("buttons"));
                if (bizData != null) {
                    rawData.put("parameter", bizData);
                }
            }
            windowSingleSelect.setRawData(rawData);
            if (!CollectionUtils.isEmpty(bizData) && StringUtil.isNotEmpty((String) bizData.get(uiBotFieldLayout.getSchema()))) {
                windowSingleSelect.setDefaultShowValue((String) bizData.get(uiBotFieldLayout.getSchema()));
            }
        }
        windowSingleSelect.setRequired(required);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(request.getLocale(), "请选择"));
        windowSingleSelect.setEnable(enable != null && enable);
        Action submitAction = new Action();
        submitAction.setType(ActionTypeEnum.CALL_API.getValue());
        Map<String, Object> rawData = new HashMap<>(1);
        rawData.put("biz_id", "ZTB");
        rawData.put("page_id", request.getPageId());
        rawData.put("pcUibotModel", pcUiBotModel);
        submitAction.setRawData(rawData);
        windowSingleSelect.setSubmitAction(submitAction);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotFieldLayout, Boolean required,
                                                 String url, String locale, UiBotExecuteContext executeContext, Boolean enable,
                                                 Map<String, Object> bizData, String schema, List<UiBotRule> ruleList) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        if (uiBotFieldLayout != null) {
            windowSingleSelect.setSchema(uiBotFieldLayout.getSchema());
            windowSingleSelect.setTitle(uiBotFieldLayout.getHeaderName());
            Map<String, Object> rawData = new HashMap<>();
            if (uiBotFieldLayout.getOperations() != null && uiBotFieldLayout.getOperations().size() > 0) {
                JSONObject operation = uiBotFieldLayout.getOperations().getJSONObject(0);
                JSONObject openWindowDefine = operation.getJSONObject("openWindowDefine");
                if (openWindowDefine != null) {
                    List<UiBotTableColumnDefinition> columnDefs = uiBotFieldLayout.getColumnDefs();
                    if (columnDefs == null) {
                        if (!StringUtils.hasLength(windowSingleSelect.getTitle())) {
                            windowSingleSelect.setTitle(openWindowDefine.getString("title"));
                        }
                    } else {
                        Boolean isFind = false;
                        for (UiBotTableColumnDefinition columnDefinition : columnDefs) {
                            List<UiBotTableColumn> columns = columnDefinition.getColumns();
                            for (UiBotTableColumn column : columns) {
                                if (schema.equals(column.getSchema())) {
                                    operation = column.getOperations().getJSONObject(0);
                                    if (!StringUtils.hasLength(windowSingleSelect.getTitle())) {
                                        windowSingleSelect.setTitle(column.getHeaderName());
                                    }
                                    isFind = true;
                                    break;
                                }
                            }
                            if (isFind) {
                                break;
                            }
                        }
                    }
                }
                if (operation.getJSONObject("openWindowDefine") != null) {
                    rawData.put("dataSourceSet",
                            operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("dataSourceSet"));
                    rawData.put("defaultShow",
                            operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getBooleanValue("defaultShow"));
                    JSONObject executeContextObj =
                            operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("executeContext");
                    if (executeContextObj != null) {
                        rawData.put("executeContext", executeContextObj);
                    } else {
                        rawData.put("executeContext", executeContext);
                    }
                    rawData.put("multipleSelect",
                            operation.getJSONObject("openWindowDefine").getBooleanValue("multipleSelect"));
                    rawData.put("selectedFirstRow",
                            operation.getJSONObject("openWindowDefine").getBooleanValue("selectedFirstRow"));
                    rawData.put("queryTagSuffix", "DIALOG");
                    rawData.put("buttons",
                            operation.getJSONObject("openWindowDefine").getJSONArray("buttons"));
                }
                if (bizData != null) {
                    rawData.put("parameter", bizData);
                }
            }
            windowSingleSelect.setRawData(rawData);
        }
        windowSingleSelect.setRequired(required);
        if (bizData != null && bizData.get(schema) instanceof String) {
            windowSingleSelect.setDefaultShowValue((String) bizData.get(schema));
        }
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> schema.equalsIgnoreCase(uiBotRule.getSchema()))
                    .forEach(uiBotRule -> {
                        if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                            windowSingleSelect.setRequired("required".equalsIgnoreCase(uiBotRule.getKey()));
                        }
                    });
        }
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setEnable(enable == null ? false : enable);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotLayout, String url, String locale) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
        Map<String, Object> rawData = new HashMap<>();
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setIsNew(true);
        windowSingleSelect.setHidden(true);
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotLayout, String url, String locale,
                                                 Map<String, Object> rawData, List<Rule> ruleList) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setIsNew(true);
        windowSingleSelect.setHidden(false);
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(true);
        windowSingleSelect.setEnable(true);
        RelationRule relationRule = new RelationRule();
        for (Rule rule : ruleList) {
            if (RuleSubcategoryEnum.COMMON.getSubcategory().equalsIgnoreCase(rule.getSubcategory())) {
                relationRule.getRuleList().add(rule.getCommonRule());
            }
        }
        windowSingleSelect.setRelationRule(relationRule);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotLayout, String url, String locale,
                                                 Map<String, Object> rawData) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setHidden(false);
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(true);
        windowSingleSelect.setEnable(true);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotLayout, String url, String locale,
                                                 Map<String, Object> rawData, LocaleService localeService) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setHidden(false);
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(true);
        windowSingleSelect.setEnable(true);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotLayout, String url, String locale,
                                                 Map<String, Object> rawData, LocaleService localeService,
                                                 String defaultShowValue, String defaultShowId, Boolean required) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setHidden(false);
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(required);
        windowSingleSelect.setEnable(required);
        windowSingleSelect.setDefaultShowValue(defaultShowValue);
        windowSingleSelect.setDefaultSelectId(defaultShowId);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotLayout, String url, String locale,
                                                 Map<String, Object> rawData, LocaleService localeService,
                                                 String defaultShowValue, Boolean required, Boolean enable) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setHidden(false);
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(required);
        windowSingleSelect.setEnable(enable);
        windowSingleSelect.setDefaultShowValue(defaultShowValue);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(UiBotLayout uiBotLayout, UiBotPageData pageData, String url, String locale, Map<String, Object> rawData, Boolean showAddIcon) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        HashMap<String, Object> actions = (HashMap<String, Object>) pageData.get(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getmLabelText().get(locale));
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setIsNew(true);
        windowSingleSelect.setHidden(false);
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(true);
        windowSingleSelect.setEnable(true);
        windowSingleSelect.setShowAddIcon(showAddIcon);
        windowSingleSelect.setAddIconData((Integer) actions.get("addIconData"));
        Action action = JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(actions.get("addAction")), Action.class);
        if (action == null) {
            action = new Action();
        } else {
            action.setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, action.getJumpPageTitle()));
        }
        windowSingleSelect.setAddAction(action);
        return windowSingleSelect;
    }

    public static InputWindowSingleSelect create(String title, String schema, String url,
                                                 String locale, Map<String, Object> rawData,
                                                 String defaultSelectId, String defaultShowValue,
                                                 RelationRule relationRule, Map<String, Object> detail) {
        InputWindowSingleSelect inputWindowSingleSelect = new InputWindowSingleSelect();
        inputWindowSingleSelect.setSchema(schema);
        inputWindowSingleSelect.setUrl(url);
        inputWindowSingleSelect.setTitle(title);
        inputWindowSingleSelect.setRawData(rawData);
        inputWindowSingleSelect.setDetail(detail);
        inputWindowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        inputWindowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        inputWindowSingleSelect.setDefaultSelectId(defaultSelectId);
        inputWindowSingleSelect.setDefaultShowValue(defaultShowValue);
        inputWindowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        inputWindowSingleSelect.setRequired(true);
        inputWindowSingleSelect.setEnable(true);
        inputWindowSingleSelect.setShowAddIcon(false);
        inputWindowSingleSelect.setHasSearch(true);
        inputWindowSingleSelect.setRelationRule(relationRule);
        return inputWindowSingleSelect;
    }

    public static InputWindowSingleSelect create(Map<String, Object> rawData, String schema, String title, String url, String locale, boolean isRequired) {
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(schema);
        windowSingleSelect.setTitle(title);
        windowSingleSelect.setRawData(rawData);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请选择"));
        windowSingleSelect.setRequired(isRequired);
        return windowSingleSelect;
    }


    /**
     * 弹窗 定义 -- 设计器新增属性 -- 24S1迭代 针对开窗配置改造，使用列表。不可删除，兼容历史卡配置
     */
    private PcUiBotTmOperation openWindowDefine;
    /**
     * 开启分页
     */
    private Boolean useHasNext;
    /**
     * 分页参数
     */
    private Integer pageSize;
    /**
     * 开窗列表 定义 -- 设计器新增属性
     */
    private List<PcUiBotTmOperation> operations;
    /**
     * 返回给前端的 开窗配置列表 -- 根据condition为true获取对应的开窗配置
     */
    private List<OpenWindowConfig> openWindowConfigList;

    /**
     * 返回给前端的 回填字段scheme列表，前端通过此列表中对应scheme，找到当前页面的其它栏位，然后从detail中获取对应值回填到其它栏位
     */
    private List<String> backFillList;

    @Data
    @Accessors(chain = true)
    private static class OpenWindowConfig {
        private String name;
        private String condition;
        private String defaultSelectId;
        private String defaultShowValue;
        private Map<String, Object> rawData;
        private Boolean useHasNext = false;
        private Integer pageSize = 50;
        private List<String> backFillList;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.url = AppContext.getBaseUrl() + "/data/entry/window/data/list";
        this.openWindowConfigList =
                this.buildOpenWindowConfigList(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData,
                        this.openWindowDefine, this.operations);
        if (!CollectionUtils.isEmpty(this.openWindowConfigList)) {
            OpenWindowConfig openWindowConfig = this.openWindowConfigList.get(0);
            if (this.openWindowConfigList.size() == 1) {
                // 开窗配置一个时，条件默认为true
                openWindowConfig.setCondition("true");
            }
            this.defaultSelectId = openWindowConfig.getDefaultSelectId();
            this.defaultShowValue = openWindowConfig.getDefaultShowValue();
            this.rawData = openWindowConfig.getRawData();
            this.useHasNext = openWindowConfig.getUseHasNext();
            this.pageSize = openWindowConfig.getPageSize();
            this.backFillList = openWindowConfig.getBackFillList();
        }
        // clear
        this.openWindowDefine = null;
        this.operations = null;
        //提示语给默认值
        if (ObjectUtils.isEmpty(this.placeholder)) {
            this.placeholder = localeService.getLanguageValue(executeContext.getLocale(), "请选择");
        }
    }

    private List<OpenWindowConfig>
    buildOpenWindowConfigList(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                              PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData,
                              PcUiBotTmOperation openWindowDefine, List<PcUiBotTmOperation> operations) {
        List<OpenWindowConfig> openWindowConfigList = new ArrayList<>();
        List<PcUiBotTmOperation> tmOperations = this.buildTmOperations(openWindowDefine, operations);
        if (CollectionUtils.isEmpty(tmOperations)) {
            return openWindowConfigList;
        }
        TmPageOperationService tmPageOperationService = SpringContextHolder.getBean(TmPageOperationService.class);
        for (PcUiBotTmOperation tmOperation : tmOperations) {
            openWindowConfigList.add(
                    this.buildOpenWindowConfig(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData,
                            tmOperation, tmPageOperationService));
        }
        return openWindowConfigList;
    }

    private List<PcUiBotTmOperation> buildTmOperations(PcUiBotTmOperation openWindowDefine, List<PcUiBotTmOperation> operations) {
        // 先取列表数据配置，如果存在直接返回，否则取明细配置
        if (!CollectionUtils.isEmpty(operations)) {
            operations.forEach(operation -> operation.setOperate("openwindow"));
            return operations;
        }
        if (openWindowDefine == null) {
            return new ArrayList<>();
        }
        PcUiBotTmOperation tmOperation = new PcUiBotTmOperation();
        tmOperation.setOperate("openwindow");
        tmOperation.setOpenWindowDefine(openWindowDefine.getOpenWindowDefine());
        return Lists.newArrayList(tmOperation);
    }

    private OpenWindowConfig
    buildOpenWindowConfig(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                          PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData,
                          PcUiBotTmOperation tmOperation, TmPageOperationService tmPageOperationService) {
        PcUiBotOperationDTO operationDTO = new PcUiBotOperationDTO();
        tmPageOperationService.parseOpenWindow(executeContext, false, tmOperation, operationDTO);
        PcUiBotOpenWindowDefineDTO openWindowDefine = operationDTO.getOpenWindowDefine();

        OpenWindowConfig openWindowConfig = new OpenWindowConfig().setName(openWindowDefine.getTitle()).setCondition(operationDTO.getOpenWindowConditional());
        if (openWindowDefine.getAllAction() == null) {
            return openWindowConfig;
        }

        Map<String, Object> rawData = new HashMap<>();
        // rawdata中存入代理token，此值在拦截器中处理
        rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
        rawData.put("dataSourceSet", openWindowDefine.getAllAction().getDataSourceSet());
        rawData.put("dataKeys", openWindowDefine.getAllAction().getDataSourceSet().getDataKeys());
        rawData.put("defaultShow", openWindowDefine.getAllAction().isDefaultShow());
        rawData.put("executeContext", openWindowDefine.getAllAction().getExecuteContext());
        rawData.put("multipleSelect", openWindowDefine.getMultipleSelect());
        rawData.put("selectedFirstRow", openWindowDefine.getSelectedFirstRow());
        rawData.put("queryTagSuffix", "DIALOG");
        rawData.put("pageInfo", openWindowDefine.getAllAction().getPageInfo());
        rawData.put("roleAttention", openWindowDefine.getRoleAttention());
        rawData.put("drilDownButton", buildDrilDownButton(openWindowDefine.getMobileDrilDown(), cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData));
        rawData.put("mobileSortInfo", openWindowDefine.getMobileSortInfo());
        // wjw FIXME: 2023/11/8 开窗页面构建时需要schema，根据schema获取mock数据或试验优测定制根据schema处理相关逻辑
        rawData.put("schema", schema);
        rawData.put("useHasNext", Optional.ofNullable(openWindowDefine.getUseHasNext()).orElse(false));
        rawData.put("buttons", openWindowDefine.getButtons());
        rawData.put("applyToArray", openWindowDefine.getApplyToArray());
        rawData.put("applyToField", openWindowDefine.getApplyToField());
        rawData.put("parameter", data);
        if ("esp_wo.op.request.support.approve.info.get".equals(openWindowDefine.getAllAction().getDataSourceSet().getFirstActionId())) {
            // wjw TODO: 2023/8/28 进度回报，请求支援，审核人员特殊处理
            Map<String, Object> body = new HashMap<>(1);
            body.put("wo_op_request_support_approve_info", Lists.newArrayList());
            rawData.put("parameter", body);
        }

        if ("questionIdentify".equalsIgnoreCase(executeContext.getTmActivityId())) {
            rawData.put("submitParam", cmptContext.getSubmitParam());
        }
        // 构建默认选中的数据
        this.buildDefaultSelect(openWindowConfig, data, mobilePath, schema, openWindowDefine.getAllAction().getDataSourceSet().getDataKeys(), openWindowDefine.getButtons(), executeContext, openWindowDefine.getApplyToField());
        openWindowConfig.setRawData(rawData)
                .setUseHasNext(Optional.ofNullable(openWindowDefine.getUseHasNext()).orElse(false))
                .setPageSize(50)
                .setBackFillList(this.buildBackFillList(openWindowDefine.getButtons()));
        return openWindowConfig;
    }

    public static Button<UiBotAction> buildDrilDownButton(UiBotAction mobileDrilDown, ComponentContext cmptContext, String mobilePath, String schema,
                                                          Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (mobileDrilDown == null) {
            return null;
        }
        Button<UiBotAction> button = new Button<>();
        UiBotJumpAction jumpAction = Objects.isNull(mobileDrilDown.getJumpAction()) ?
                new UiBotJumpAction() : mobileDrilDown.getJumpAction();
        jumpAction.setDetailPageSwiper(false);
        mobileDrilDown.setJumpAction(jumpAction);
        button.setSubmitAction(mobileDrilDown);
        button.setDetailPageSwiper(false);
        // data 传递空对象，因为用不到，需要在构建开窗数据的地方对每笔数据增加seeMoreButton字段，传入对应的每笔选项的data
        button.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        return button;
    }

    private List<String> buildBackFillList(List<PcUiBotOpenWindowDefineButtonDTO> buttons) {
        List<String> backFillList = new ArrayList<>();
        if (CollectionUtils.isEmpty(buttons)) {
            return backFillList;
        }
        Map<String, String> backFills = BackFillsParseUtil.getBackFillMap(JsonUtil.objectToJavaObject(buttons, new TypeReference<List<Map<String, Object>>>() {
        }));
        if (backFills.isEmpty()) {
            return backFillList;
        }
        return backFills.values().stream().filter(StringUtils::hasLength).distinct().collect(Collectors.toList());
    }

    private void buildDefaultSelect(OpenWindowConfig openWindowConfig, Map<String, Object> data, String mobilePath, String schema,
                                    List<String> dataKeys, List<PcUiBotOpenWindowDefineButtonDTO> buttons, PcUiBotExecuteContext executeContext, String applyToField) {

        // open issue 一个栏位会根据条件调4个不同api，目前是同一个schema 拼接上后缀来区分，如 task_name_index_1
        if ("start_SCH_mainline_project_0001".equalsIgnoreCase(executeContext.getTmActivityId())) {
            String questionSourceScene = String.valueOf(MapUtil.getOrDefault(data, "question_source_scene", ""));
            String remindTaskScene = String.valueOf(MapUtil.getOrDefault(data, "remind_task_scene", ""));

            if ((schema.startsWith("task_name_index") && schema.endsWith(questionSourceScene))
                    || (schema.startsWith("remind_task_name_index") && schema.endsWith(remindTaskScene))) {
                mobilePath = mobilePath.substring(0, mobilePath.indexOf("_index"));
                schema = schema.substring(0, schema.indexOf("_index"));
            }
        }
        Object o = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (o == null || StringUtil.isEmpty(o.toString())) {
            return;
        }
        openWindowConfig.setDefaultSelectId(StringUtil.valueOf(o)).setDefaultShowValue(StringUtil.valueOf(o));
        if ("questionIdentify".equalsIgnoreCase(executeContext.getTmActivityId())) {
            if ("project_no".equalsIgnoreCase(schema)) {
                Object projectStageName = UiBotDesignerRenderService.getDataByPathAndSchema(data, "question_result.question_basic_info.project_name", "project_name");
                openWindowConfig.setDefaultShowValue(Objects.isNull(projectStageName) ? "" : String.valueOf(projectStageName));
            }
            if ("project_stage_no".equalsIgnoreCase(schema)) {
                Object projectStageName = UiBotDesignerRenderService.getDataByPathAndSchema(data, "question_result.question_basic_info.project_stage_name", "project_stage_name");
                openWindowConfig.setDefaultShowValue(Objects.isNull(projectStageName) ? "" : String.valueOf(projectStageName));
            }
        }
        if (CollectionUtils.isEmpty(dataKeys)) {
            return;
        }
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        Map<String, String> backFills = BackFillsParseUtil.getBackFillMap(JsonUtil.objectToJavaObject(buttons, new TypeReference<List<Map<String, Object>>>() {
        }));
        if (backFills.isEmpty()) {
            return;
        }

        // 开窗对应字段可能不是直接在data中，而在data的集合字段中
        if (mobilePath.contains(".")) {
            String substringMobilePath = mobilePath.substring(0, mobilePath.lastIndexOf("."));
            data = UiBotDesignerRenderService.getDataByMobilePath(data, substringMobilePath);
        }
        openWindowConfig.setDefaultSelectId(this.buildDefaultSelectId(data, dataKeys, backFills, applyToField));
    }

    private String buildDefaultSelectId(Map<String, Object> data, List<String> dataKeys, Map<String, String> backFills, String applyToField) {
        StringBuilder sb = new StringBuilder();
        if (data.get(applyToField) instanceof List) {
            List<Map<String, Object>> dataListByApplyToField = (List<Map<String, Object>>) MapUtil.getOrDefault(data, applyToField, Collections.emptyList());
            if (!CollectionUtils.isEmpty(dataListByApplyToField)) {
                dataKeys.forEach(dataKey -> sb.append(StringUtil.valueOf(dataListByApplyToField.get(0).get(backFills.get(dataKey)))).append(PcUiBotConstants.WINDOW_ID_SEPERATOR));
            }
        } else {
            dataKeys.forEach(dataKey -> sb.append(StringUtil.valueOf(data.get(backFills.get(dataKey)))).append(PcUiBotConstants.WINDOW_ID_SEPERATOR));
        }
        return sb.substring(0, sb.length() - PcUiBotConstants.WINDOW_ID_SEPERATOR.length()).trim();
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputWindowSingleSelect inputWindowSingleSelect = new InputWindowSingleSelect();
        inputWindowSingleSelect.setComponentId(rawContent.getComponentId());
        inputWindowSingleSelect.setTitle(rawContent.getLabel());
        inputWindowSingleSelect.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.OpenWindowSelectObj openWindowSelectObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.OpenWindowSelectObj.class);
        if (openWindowSelectObj != null) {
            inputWindowSingleSelect.setPlaceholder(openWindowSelectObj.getPlaceholder());
            inputWindowSingleSelect.setIsEdit(openWindowSelectObj.getIsEdit());
            inputWindowSingleSelect.setStyle(openWindowSelectObj.getStyle());
            inputWindowSingleSelect.setOperations(openWindowSelectObj.getOperations());
        }
        if (!CollectionUtils.isEmpty(rawContent.getSubContent())) {
            // 设置拼接的字段
            Card.DesignerRawCard.Content subContent = rawContent.getSubContent().get(0);
            String displayValue = Card.getDisplayValue(subContent, StringUtil.valueOf(data.get(subContent.getSchema())));
            inputWindowSingleSelect.setSuffixText(displayValue);
        }
        inputWindowSingleSelect.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputWindowSingleSelect;
    }
}
