package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

/**
 * @author zhangjj
 * @date 2021/7/13 0013 17:24
 */
@Component
public class InputWindowSingleSelectParamAnalyzer implements ComponentParamAnalyzer<InputWindowSingleSelect, String> {
    @Override
    public String getComponentType() {
        return InputWindowSingleSelect.COMPONENT_TYPE;
    }

    @Override
    public Class<InputWindowSingleSelect> getSubmitParamType() {
        return InputWindowSingleSelect.class;
    }

    @Override
    public String analyzeSubmitParam(Object submitParam) {
        InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) submitParam;
        return Optional.ofNullable(inputWindowSingleSelect.getSelectId()).orElse("");
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object... args) {
        Map<String, Object> displayParam = (Map<String, Object>) pageData.get(pageDataKey);
        String title = (String) displayParam.get("title");
        String url = (String) displayParam.get("url");
        displayParam.put("title", LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), title));
        displayParam.put("url", AppContext.getBaseUrl() + url);
        displayParam.put("rawData", args[0]);
    }
}
