package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 新建任務
 */
@Component("MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE")
public class BuildTaskAction implements ComponentAction{

    @Autowired
    private LocaleService localeService;

    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setJumpPageId(PortalConstans.ActionEnum.MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE.name());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(),PortalConstans.ActionEnum.MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE.getZhCNName()));
        return action;
    }
}
