package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 行事历
 */
@Component("PAGE_CALENDAR")
public class CalendarAction implements ComponentAction{

    @Autowired
    private LocaleService localeService;
    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setJumpPageId(PortalConstans.ActionEnum.MOBILE_MY_TODO.name());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(),PortalConstans.ActionEnum.PAGE_CALENDAR.getZhCNName()));
        action.setCalenderType(2);
        action.setStartDate(apiRequest.getStartDate());
        action.setEndDate(apiRequest.getEndDate());
        return action;
    }
}
