package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 自定义链接
 */
@Component("Custom")
public class CustomAction implements ComponentAction{

    @Autowired
    private LocaleService localeService;
    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
        action.setRequestUrl(mobileBallResp.getJumpTarget());
        action.setOpenWebPageTitle(localeService.getLanguageValue(apiRequest.getLocale(),mobileBallResp.getBallName()));
        return action;
    }
}
