package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 应用作业
 */
@Component("CustomApplication")
public class CustomApplicationAction implements ComponentAction{


    @Autowired
    private LocaleService localeService;

    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(),mobileBallResp.getBallName()));
        action.setRequestUrl(mobileBallResp.getCallBackUrl());
        Map<String,Object> map = new HashMap<>();
//        map.put("registerUrl",mobileBallResp.getRegisterUrl());
//        map.put("callBackUrl",mobileBallResp.getCallBackUrl());
//        map.put("applicationPrimaryId",mobileBallResp.getApplicationPrimaryId());
        map.put("customApplicationId",mobileBallResp.getCustomApplicationId());
        action.setRawData(map);
        return action;
    }
}
