package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 自定义页面
 */
@Component("CustomPage")
public class CustomPageAction implements ComponentAction{

    @Autowired
    private LocaleService localeService;
    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        action.setJumpPageId(PortalConstans.CUSTOM_PAGE_ROUTER);
        Map<String,String> map= new HashMap<>();
        if(StringUtil.isNotEmpty(mobileBallResp.getJumpTarget())){
            map.put("id",mobileBallResp.getJumpTarget());
            ////页面类型（新增字段） 0或空-门户 1-二级页
            map.put("pageType",1+"");
        }
        action.setRawData(map);
        return action;
    }
}
