package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 公告类型
 */
@Component("mobileNewsType")
public class MobileNewsTypeAction implements ComponentAction {

    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        action.setJumpPageId(PortalConstans.ActionEnum.NOTICE_LIST_PAGE.name());
        Map<String, Long> map = new HashMap<>();
        Long childrenTarget =null;
        //如果选择的是二级，是以逗号分隔，则取第一个值作为一级公告类型ID，第二个值作为二级公告类型ID
        if (StringUtil.isNotEmpty(mobileBallResp.getJumpTarget()) && mobileBallResp.getJumpTarget().contains(",")) {
            String[] newsTypeIds = mobileBallResp.getJumpTarget().split(",");
            if (newsTypeIds.length >= 2) {
                childrenTarget = Long.parseLong(newsTypeIds[1]);
                map.put("childrenNewsTypeId", childrenTarget);
                mobileBallResp.setJumpTarget(newsTypeIds[0]);
            }
        }
        //-1 表示查询的公告类型不存在
        map.put("newsTypeId", StringUtil.isNotEmpty(mobileBallResp.getJumpTarget()) ? Long.parseLong(mobileBallResp.getJumpTarget()) : -1);
        action.setRawData(map);
        return action;
    }
}
