package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 公告列表
 */
@Component("NOTICE_LIST_PAGE")
public class NewsAction implements ComponentAction{

    @Autowired
    private LocaleService localeService;

    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        action.setJumpPageId(PortalConstans.ActionEnum.NOTICE_LIST_PAGE.name());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(),PortalConstans.ActionEnum.NOTICE_LIST_PAGE.getZhCNName()));
        return action;
    }
}
