package com.digiwin.mobile.mobileuibot.core.component.kingkong.action;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 项目追踪
 */
@Component("MOBILE_ATHENA_PROJECT")
public class ProjectAction implements ComponentAction{
    @Autowired
    private LocaleService localeService;
    @Override
    public Action buildCompoentAction(ApiRequest apiRequest, MobileBallResp mobileBallResp) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setJumpPageId(PortalConstans.ActionEnum.MOBILE_ATHENA_PROJECT.name());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(),PortalConstans.ActionEnum.MOBILE_ATHENA_PROJECT.getZhCNName()));
        return action;
    }
}
