package com.digiwin.mobile.mobileuibot.core.component.layout;

/**
 * <p>功能描述：布局组件枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ComponentLayoutTypeEnum
 * @Author: Zaregoto
 * @Date: 2023/3/15 17:34
 */
public enum ComponentLayoutTypeEnum {
    /**
     * 垂直布局，类似一个列表
     */
    VERTICAL(1),

    /**
     * 流式布局
     */
    FLOW(2),

    /**
     * 网格（宫格）布局
     */
    GRID(3),

    /**
     * 线性布局
     */
    LINEAR(4),

    ;

    private Integer value;

    ComponentLayoutTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }
}
