package com.digiwin.mobile.mobileuibot.core.component.layout.app;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>功能描述：可点击的入口型应用功能</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppFunctionTouchable
 * @Author: Zaregoto
 * @Date: 2022/3/13 23:45
 */
@Data
@NoArgsConstructor
public class AppFunctionTouchable extends BottomButtonDigiwinAthena {
    private static final long serialVersionUID = 209457917522995978L;
    public static final String COMPONENT_TYPE = "APP_FUNCTION_TOUCHABLE";

    @Override
    public String returnComponentType() {
        return AppFunctionTouchable.COMPONENT_TYPE;
    }

    private AppEntranceAccessRecord accessRecord;
    // 图标
    private String iconBase64;

    public static AppFunctionTouchable create(String name, Integer iconData, String iconColor,
                                              String jumpPageId, String jumpPageTitle, Integer actionType, String requestUrl, String image, String imageUrl) {
        AppFunctionTouchable appFunctionTouchable = new AppFunctionTouchable();
        appFunctionTouchable.setName(name);
        appFunctionTouchable.setIconData(iconData);
        appFunctionTouchable.setIconColor(iconColor);
        Action action = new Action();
        action.setJumpPageId(jumpPageId);
        action.setJumpPageTitle(jumpPageTitle);
        action.setRequestUrl(requestUrl);
        ActionTypeEnum actionTypeEnum = ActionTypeEnum.getEnumByValue(actionType);
        if (null == actionTypeEnum) {
            actionTypeEnum = ActionTypeEnum.OPEN_NEW_PAGE;
        }
        action.setType(actionTypeEnum.getValue());
        appFunctionTouchable.setAction(action);
        appFunctionTouchable.setImage(image);
        appFunctionTouchable.setImageUrl(imageUrl);
        return appFunctionTouchable;
    }
}
