package com.digiwin.mobile.mobileuibot.core.component.layout.app;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>功能描述：可点击的入口型应用功能</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppFunctionTouchable
 * @Author: Zaregoto
 * @Date: 2022/3/13 23:45
 */
@Data
@NoArgsConstructor
public class AppModuleItem extends BottomButtonDigiwinAthena {
    private static final long serialVersionUID = -6726697842822820033L;

    public static final String COMPONENT_TYPE = "APP_MODULE_ITEM";

    @Override
    public String returnComponentType() {
        return AppModuleItem.COMPONENT_TYPE;
    }

    //是否置顶
    private Boolean isTop;

    private String parentCode;

    private String parentName;

    public static AppModuleItem create(String name, Integer iconData, String iconColor,
                                              String jumpPageId, String jumpPageTitle,
                                       Integer actionType, String requestUrl,
                                       String image, String imageUrl) {
        AppModuleItem appModuleItem = new AppModuleItem();
        appModuleItem.setName(name);
        appModuleItem.setIconData(iconData);
        appModuleItem.setIconColor(iconColor);
        Action action = new Action();
        action.setJumpPageId(jumpPageId);
        action.setJumpPageTitle(jumpPageTitle);
        action.setRequestUrl(requestUrl);
        ActionTypeEnum actionTypeEnum = ActionTypeEnum.getEnumByValue(actionType);
        if (null == actionTypeEnum) {
            actionTypeEnum = ActionTypeEnum.OPEN_NEW_PAGE;
        }
        action.setType(actionTypeEnum.getValue());
        appModuleItem.setAction(action);
        appModuleItem.setImage(image);
        appModuleItem.setImageUrl(imageUrl);
        return appModuleItem;
    }
}
