package com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：应用入口布局组件，有限制的布局类型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppEntrance
 * @Author: Zaregoto
 * @Date: 2022/2/25 1:34
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AppEntrance extends BaseLayoutMobileComponent {
    private static final long serialVersionUID = -8430157681299956778L;
    public static final String COMPONENT_TYPE = "APP_ENTRANCE";

    @Override
    public String returnComponentType() {
        return AppEntrance.COMPONENT_TYPE;
    }

    @Override
    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.GRID;
    }

    /**
     * 应用入口的布局方式
     *
     * @see AppEntranceLayoutTypeEnum
     */
    private Integer appLayoutType;

    /**
     * 应用入口清单
     */
    private List<AppFunctionTouchable> appList = new ArrayList<>();

    /**
     * 应用排列方向
     *
     * @see AppEntranceDirectionEnum
     */
    private Integer direction;

    /**
     * 入口标题
     */
    private String title;

    /**
     * 标题样式；0-正常粗细；1-标题粗体
     *
     * @see AppEntranceTitleStyleEnum
     */
    private Integer titleStyle;

    @Override
    public void initSetting(String locale) {
        super.initSetting(locale);

        this.setTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, this.getTitle()));
        if (null != this.getAppList() && !this.getAppList().isEmpty()) {
            this.getAppList().forEach(buttonApp -> {
                buttonApp.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, buttonApp.getName()));
                this.setAppRequestUrl(buttonApp);
                this.setAppJumpPageTitle(locale, buttonApp);
                this.setAppToastMsg(locale, buttonApp);
            });
        }
    }

    private void setAppToastMsg(String locale, AppFunctionTouchable buttonApp) {
        String toastMsg = Optional.ofNullable(buttonApp.getAction()).map(Action::getToastMsg).orElse("");
        if (!toastMsg.isEmpty()) {
            buttonApp.getAction().setToastMsg(LocaleUtil.getMobileTextByDatabaseKey(locale, toastMsg));
        }
    }

    private void setAppRequestUrl(AppFunctionTouchable buttonApp) {
        String requestUrl = Optional.ofNullable(buttonApp.getAction()).map(Action::getRequestUrl).orElse("");
        if (!requestUrl.isEmpty()) {
            if (!requestUrl.startsWith("http")) {
                requestUrl = AppContext.getBaseUrl() + requestUrl;
            }
            buttonApp.getAction().setRequestUrl(requestUrl);
        }
    }

    private void setAppJumpPageTitle(String locale, AppFunctionTouchable buttonApp) {
        String jumpPageTitle = Optional.ofNullable(buttonApp.getAction()).map(Action::getJumpPageTitle).orElse("");
        if (!jumpPageTitle.isEmpty()) {
            buttonApp.getAction().setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, jumpPageTitle));
        }
    }
}
