package com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance;

import lombok.Data;

import java.io.Serializable;

/**
 * 应用入口访问记录
 *
 * @author zhangjj
 * @date 2022/11/29 11:45
 */
@Data
public class AppEntranceAccessRecord implements Serializable {
    private static final long serialVersionUID = -1982555898534314394L;

    /**
     * 是否发送记录请求
     */
    private Boolean sendRecord;

    /**
     * 记录接口地址
     */
    private String recordUrl;

    public void convert(AppEntranceAccessRecord accessRecord) {
        if (null == accessRecord) {
            return;
        }
        if (null != accessRecord.getSendRecord()) {
            this.sendRecord = accessRecord.getSendRecord();
        }
        if (null != accessRecord.getRecordUrl()) {
            this.recordUrl = accessRecord.getRecordUrl();
        }
    }
}
