package com.digiwin.mobile.mobileuibot.core.component.layout.container;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：放置组件的容器类型组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Container
 * @Author: Zaregoto
 * @Date: 2022/2/25 19:27
 */
@Data
@AllArgsConstructor
public class Container extends BaseMobileComponent {
    private static final long serialVersionUID = -2602606595103455347L;
    public static final String COMPONENT_TYPE = "CONTAINER";

    @Override public String returnComponentType() {
        return Container.COMPONENT_TYPE;
    }

    public static final String LESS_TEXT_SUFFIX_SYMBOL = "∧";
    public static final String MORE_TEXT_SUFFIX_SYMBOL = "∨";

    private List<ContainerContent> contentList;

    /**
     * 是否存在查看更多按钮
     * true-存在，false-不存在。当该值为true时，heightThreshold才生效
     */
    private Boolean hasShowMore;

    /**
     * 容器高度阈值。<br/>
     * 可用值在0.0~1.0之间，用于控制可展示的高度，等于1时表示占满整个屏幕的高度。若实际展示内容高度超过该值，则会被隐藏，只能用“查看更多”按钮展示更多内容<br/>
     * 默认值是0.3
     */
    private Double heightThreshold;

    private String showLessText;

    private String showMoreText;

    public Container() {
        this.contentList = new ArrayList<>();
        this.hasShowMore = true;
        this.heightThreshold = 0.3;
        this.showLessText = "Less";
        this.showMoreText = "More";
        this.appendShowLessTextSuffix();
        this.appendShowMoreTextSuffix();
    }

    public void setShowLessText(String showLessText) {
        this.showLessText = showLessText;
    }

    public void setShowMoreText(String showMoreText) {
        this.showMoreText = showMoreText;
    }

    private void appendShowLessTextSuffix() {
        this.setShowLessText(this.getShowLessText() + " " + LESS_TEXT_SUFFIX_SYMBOL);
    }

    private void appendShowMoreTextSuffix() {
        this.setShowMoreText(this.getShowMoreText() + " " + LESS_TEXT_SUFFIX_SYMBOL);
    }
}
