package com.digiwin.mobile.mobileuibot.core.component.layout.container;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：Container组件的内容类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ContainerContent
 * @Author: Zaregoto
 * @Date: 2022/2/25 19:30
 */
@Data
@AllArgsConstructor
public class ContainerContent implements Serializable {
    private static final long serialVersionUID = 8510018482221725041L;

    /**
     * 组件分组
     * 在这个List中，每个UiBotModel对象的layout都只有一个元素
     */
    private List<UiBotModel> groupList;

    /**
     * 分组布局类型。默认是EXCLUSIVE_ONE_LINE
     * @see ContainerContentGroupLayoutTypeEnum
     */
    private Integer groupLayoutType = 1;

    public ContainerContent() {
        this.groupList = new ArrayList<>();
        this.groupLayoutType = ContainerContentGroupLayoutTypeEnum.EXCLUSIVE_ONE_LINE.getValue();
    }
}
