package com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：头身容器组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: HeadBodyContainer
 * @Author: Zaregoto
 * @Date: 2022/2/25 20:57
 */
@Data
@AllArgsConstructor
public class HeadBodyContainer extends BaseMobileComponent {
    private static final long serialVersionUID = 1188011492736448615L;
    public static final String COMPONENT_TYPE = "HEAD_BODY_CONTAINER";

    @Override public String returnComponentType() {
        return HeadBodyContainer.COMPONENT_TYPE;
    }

    private HeadBodyContainerHead head;
    private List<HeadBodyContainerBody> body;

    public HeadBodyContainer() {
        this.head = new HeadBodyContainerHead();
        this.body = new ArrayList<>(3);
    }

}
