package com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.Container;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContent;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContentGroupLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchItemList;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.search.model.SmartPreciseSearchListBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：头身容器组件构造器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: HeadBodyContainerBuilder
 * @Author: Zaregoto
 * @Date: 2022/2/25 22:08
 */
@Component("headBodyContainerBuilder")
public class HeadBodyContainerBuilder implements MobileComponentBuilder<HeadBodyContainer> {

    private static final Logger logger = LoggerFactory.getLogger(HeadBodyContainerBuilder.class);

    @Override
    public String getMobileComponentType() {
        return HeadBodyContainer.COMPONENT_TYPE;
    }

    @Autowired
    private SmartPreciseSearchListBuilder smartPreciseSearchListBuilder;

    @Override
    public HeadBodyContainer build(ApiRequest apiRequest, PageSetting pageSetting,
                                   UiBotModel pcUiBotModel, Class<HeadBodyContainer> clazz, Object... args) {
        Assert.isInstanceOf(Map.class, args[0], "dataKeyMatchedBizData must NOT be null!");
        Map<String, Object> dataKeyMatchedBizData = (Map<String, Object>) args[0];

        Assert.isInstanceOf(List.class, args[1], "not instanceof List.class!");
        List<ColumnTag> columnTagList = (List<ColumnTag>) args[1];

        Assert.isInstanceOf(UiBotLayout.class, args[2], "not instanceof UiBotLayout.class!");
        UiBotLayout pageSettingLayout = (UiBotLayout) args[2];

        HeadBodyContainer headBodyContainer = new HeadBodyContainer();
        HeadBodyContainerHead headBodyContainerHead = new HeadBodyContainerHead();
        String locale = apiRequest.getLocale();
        String dataKey = (String) apiRequest.getRawData().get("dataKey");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();

        Map<String, Object> map = (Map<String, Object>) pageData.get(pageSettingLayout.getSchema());
        if (map.get("head") != null) {
            Map<String, Object> headMap = (Map<String, Object>) map.get("head");
            if (headMap != null && headMap.size() > 0) {
                List<Map<String, Object>> headLayOut = (List<Map<String, Object>>) headMap.get("layout");
                String schema = "";
                if (headLayOut != null && headLayOut.size() > 0) {
                    //目前就一个组件
                    for (Map<String, Object> lay1 : headLayOut) {
                        if (Container.COMPONENT_TYPE.equals(lay1.get("type"))) {
                            schema = (String) lay1.get("schema");
                            break;
                        }
                    }
                    if (schema != null && !schema.trim().equals("")) {
                        Map<String, Object> pageDataOut = (Map<String, Object>) headMap.get("pageData");
                        Container container = null;
                        if (pageDataOut != null && pageDataOut.size() > 0) {
                            container = JsonUtil.objectToJavaObject(pageDataOut.get(schema), Container.class);
                            container.setShowLessText(LocaleUtil.getMobileTextByDatabaseKey(locale, container.getShowLessText()) + Container.LESS_TEXT_SUFFIX_SYMBOL);
                            container.setShowMoreText(LocaleUtil.getMobileTextByDatabaseKey(locale, container.getShowMoreText()) + Container.MORE_TEXT_SUFFIX_SYMBOL);
                            container.setContentList(buildContentList(pcUiBotModel, dataKeyMatchedBizData, columnTagList, locale));
                            pageDataOut.put(schema, JsonUtil.objectToJavaObject(container, Map.class));
                        }
                        headBodyContainerHead.setPageData(JsonUtil.objectToJavaObject(pageDataOut, UiBotPageData.class));
                        UiBotLayout uiBotLayout = JsonUtil.objectToJavaObject(headLayOut.get(0), UiBotLayout.class);
                        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
                        uiBotLayouts.add(uiBotLayout);
                        headBodyContainerHead.setLayout(uiBotLayouts);
                        headBodyContainer.setHead(headBodyContainerHead);
                    }

                }
            }

        }
        if (map.get("body") != null) {
            List<Map<String, Object>> bodyMaps = (List<Map<String, Object>>) map.get("body");
            if (bodyMaps != null && bodyMaps.size() > 0) {
                List<HeadBodyContainerBody> headBodyContainerBodies = new ArrayList<>(bodyMaps.size());
                for (Map<String, Object> bodyMap : bodyMaps) {
                    List<Map<String, Object>> bodyLayOuts = (List<Map<String, Object>>) bodyMap.get("layout");
                    if (bodyLayOuts == null || bodyLayOuts.size() == 0) {
                        continue;
                    }
                    Map<String, Object> bodyLayout = bodyLayOuts.get(0);
                    Map<String, Object> bodyPageData = (Map<String, Object>) bodyMap.get("pageData");
                    String schema = (String) bodyLayout.get("schema");
                    List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
                    uiBotLayouts.add(JsonUtil.objectToJavaObject(bodyLayout, UiBotLayout.class));

                    if (Webview.COMPONENT_TYPE.equals(bodyLayout.get("type"))) {
                        HeadBodyContainerBody headBodyContainerBody = new HeadBodyContainerBody();
                        headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByKey(locale, (String) bodyMap.get("title")));

                        Webview webview = Optional.ofNullable(JsonUtil.objectToJavaObject(bodyPageData.get(schema), Webview.class)).orElse(new Webview());
                        String resultUrl = this.buildUrl(pcUiBotModel, dataKeyMatchedBizData, columnTagList, webview.getUrl());
                        if (StringUtils.hasLength(resultUrl) && !resultUrl.toLowerCase().contains("null")) {
                            webview.initSetting(locale);
                            webview.setUrl(resultUrl);
                            headBodyContainerBody.setLayout(uiBotLayouts);
                            bodyPageData.put(schema, JsonUtil.objectToJavaObject(webview, Map.class));
                            headBodyContainerBody.setPageData(JsonUtil.objectToJavaObject(bodyPageData, UiBotPageData.class));
                        } else {
                            headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "暂无数据");
                        }
                        headBodyContainerBodies.add(headBodyContainerBody);
                    } else if (SmartPreciseSearchItemList.COMPONENT_TYPE.equals(bodyLayout.get("type"))) {
                        String id = pcUiBotModel.getContent().getActivityId();
                        List<Map<String, Object>> list = (List<Map<String, Object>>) bodyPageData.get(schema);
                        String countNumText = "";
                        if (list != null && list.size() > 0) {
                            Map<String, Object> data = (Map<String, Object>) list.get(0).get("data");
                            countNumText = (String) data.get("countNumText");
                        }
                        List<SmartPreciseSearch> smartPreciseSearches = null;
//                        smartPreciseSearches = buildSmartPreciseSearch(pcUiBotModel, dataKeyMatchedBizData, columnTagList, dataKey, locale);

                        // 设置在pageSetting中的path，用于识别需要读取的数据路径。示例值：graph_info.history_cad_info
                        List<Map<String, Object>> pathInfos = (List<Map<String, Object>>) bodyMap.get("pathInfo");
                        String path = "";
                        for (Map<String, Object> pathInfo : pathInfos) {
                            if (id != null && id.contains((String) pathInfo.get("id"))) {
                                path = (String) pathInfo.get("path");
                                break;
                            }
                        }
                        smartPreciseSearches = this.smartPreciseSearchListBuilder.build(apiRequest, null,
                                pcUiBotModel, SmartPreciseSearch.class,
                                apiRequest.getRawData().get("params"),
                                apiRequest.getRawData().getString("tmActivityId"),
                                path,
                                dataKeyMatchedBizData
                        );

                        SmartPreciseSearchItemList smartPreciseSearchItemList = new SmartPreciseSearchItemList(countNumText);
                        smartPreciseSearchItemList.addAllComponentsToList(smartPreciseSearches,
                                SmartPreciseSearch.COMPONENT_TYPE + "_ITEM");

                        bodyPageData.put(schema, smartPreciseSearchItemList);

                        HeadBodyContainerBody headBodyContainerBody = new HeadBodyContainerBody();
                        headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, (String) bodyMap.get("title")));
                        if (smartPreciseSearchItemList.isNotEmpty()) {
                            headBodyContainerBody.setLayout(uiBotLayouts);
                            headBodyContainerBody.setPageData(JsonUtil.objectToJavaObject(bodyPageData, UiBotPageData.class));
                        } else {
                            headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "暂无数据");
                        }

                        headBodyContainerBodies.add(headBodyContainerBody);
                    }
                }
                headBodyContainer.setBody(headBodyContainerBodies);
            }
        }


        /**
         * TODO
         * 生成HeadBodyContainer组件步骤如下：
         * 1. head部分：HeadBodyContainerHead类
         *   使用com.digiwin.mobile.mobileuibot.core.component.layout.container.Container组件填充
         *   1.1. 依照PageSetting中设置的内容设置Container的其他属性：hasShowMore、heightThreshold、showLessText、showMoreText
         *          **注意**
         *          （1）showLessText、showMoreText需使用LocaleUtil.getMobileTextByDatabaseKey设置多语言
         *   1.2. 从columnTagList筛选出ColumnTag.TagDefinition.code=mobile_DISPLAY_GROUP的数据，表示要分组的字段
         *   1.3. 根据ColumnTag.groupNo的分组序号的最大值，决定Container.contentList的数量；
         *        根据ColumnTag.groupItemNo的分组内元素序号的最大值，决定Container.contentList.groupList的数量
         *        **注意**
         *        （1）若两个ColumnTag的groupNo相同表示它们在同一组内，即都会放在Container.contentList.groupList中；
         *        （2）若某个group内只有1项，将该group布局设置为独占一行，则Container.contentList.groupLayoutType=ContainerContentGroupLayoutTypeEnum.EXCLUSIVE_ONE_LINE.getValue()
         *             若某个group内大于1项，将该group布局设置为共享一行并自动往下，则Container.contentList.groupLayoutType=ContainerContentGroupLayoutTypeEnum.SHARE_ONE_LINE_AND_OVERFLOW_WITH_NEW_LINE.getValue()
         *   1.4. 根据ColumnTag中的字段内容，调用Field组件的create方法生成组件（若没有合适的则新增），
         *        并参照UiBotModel的格式，添加到Container.contentList.groupList中
         *        **注意**
         *        (1) Container.groupList.layout数组，里面只会有一个组件，即Field。用数组是为了复用动态渲染的数据结构，所以略复杂一些
         *        (2) Field组件的对齐方式Field.alignmentType统一设置成FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue()
         * 2. body部分：List<HeadBodyContainerBody>
         *    依照PageSetting中设置的内容，每个HeadBodyContainerBody的title属性需使用LocaleUtil.getMobileTextByDatabaseKey设置多语言
         *    2.1. 前2个HeadBodyContainerBody：
         *    同时依据HeadBodyContainerBody.layout[0].type的值，每个HeadBodyContainerBody.pageData中的对象转换为Webview进行处理，
         *    并对读取到的配置url替换以下占位字符串：
         *      - ${athena_host} ==> 替换为 AppContext.getApiUrlSetting().getTbbUrl()
         *      - ${cad_info.graph_info.online_drawing_format} ==> 替换成PC业务数据pageData.cad_info.graph_info.online_drawing_format，转为字符串
         *      - ${cad_info.graph_info.cad_url} ==> 替换成PC业务数据pageData.cad_info.graph_info.cad_url，转为字符串
         *      - ${cad_info.graph_info.cad_url_3d} ==> 替换成PC业务数据pageData.cad_info.graph_info.cad_url_3d，转为字符串
         *    2.2. 第3个HeadBodyContainerBody：
         *    和前端商量一下是否可以按照MongoDB中配置的结构把一个列表数据给前端，即和精准搜索时大致一样的结构：
         *      SMART_PRECISE_SEARCH_ITEM_LIST是SMART_PRECISE_SEARCH_ITEM的一个列表，列表中的数据均使用SMART_PRECISE_SEARCH_ITEM
         */


        return headBodyContainer;
    }

    private List<SmartPreciseSearch> buildSmartPreciseSearch(UiBotModel pcUiBotModel,
                                                             Map<String, Object> dataKeyMatchedBizData, List<ColumnTag> columnTagList, String dataKey, String locale) {
        List<UiBotLayout> uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }
        UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();
        String schema = pcUiBotModel.searchBizDataSchema();

        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        // 分解出明细数据行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition
                .decomposeTableColumnDefinitions(tableColumnDefinitionList);
        return getSmartPreciseSearchListByBizData(schema, dataKeyMatchedBizData, pcUiBotModel, columnTagList, tableColumns, locale);
    }

    private List<SmartPreciseSearch> getSmartPreciseSearchListByBizData(String path, Map<String, Object> keyBizData,
                                                                        UiBotModel pcUiBotModel, List<ColumnTag> columnTagList, List<UiBotTableColumn> tableColumns,
                                                                        String locale) {
        // 分组字段tag
        List<ColumnTag> groupTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                .collect(Collectors.toList());

        List<SmartPreciseSearchField> smartPreciseSearchFields = new ArrayList<>(groupTagList.size());
        for (ColumnTag columnTag : groupTagList) {
            SmartPreciseSearchField smartPreciseSearchField = new SmartPreciseSearchField();
            for (UiBotTableColumn column : tableColumns) {
                if (columnTag.getSchema().equals(column.getSchema())) {
                    smartPreciseSearchField.setFieldId(columnTag.getSchema());
                    smartPreciseSearchField.setFieldLayoutType(1);
                    smartPreciseSearchField.setFieldTitle(column.getHeaderName());
                    smartPreciseSearchFields.add(smartPreciseSearchField);
                    break;
                }
            }
        }
        List<SmartPreciseSearch> smartPreciseSearches = new ArrayList<>();
        List<Map<String, Object>> graphInfoList = (List<Map<String, Object>>) keyBizData.get("graph_info");
        if (graphInfoList != null && graphInfoList.size() > 0) {
            List<Map<String, Object>> historyCadInfoList = (List<Map<String, Object>>) graphInfoList.get(0).get("history_cad_info");
            if (historyCadInfoList != null && historyCadInfoList.size() > 0) {
                for (Map<String, Object> bizData : historyCadInfoList) {
                    SmartPreciseSearch smartPreciseSearch = new SmartPreciseSearch();
                    //塞入其他字段
                    for (SmartPreciseSearchField smartPreciseSearchField : smartPreciseSearchFields) {
                        if (smartPreciseSearchField.getFieldId() == null) {
                            continue;
                        }
                        if (bizData.get(smartPreciseSearchField.getFieldId()) instanceof String) {
                            smartPreciseSearchField.setFieldValue((String) bizData.get(
                                    smartPreciseSearchField.getFieldId()));
                        } else {
                            smartPreciseSearchField.setFieldValue(String.valueOf(bizData.get(
                                    smartPreciseSearchField.getFieldId())));
                        }

                    }
                    smartPreciseSearch.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
                    smartPreciseSearch.setFields(smartPreciseSearchFields);
                    smartPreciseSearches.add(smartPreciseSearch);
                }
            }
        }
        return smartPreciseSearches;
    }

    private String buildUrl(UiBotModel pcUiBotModel, Map<String, Object> dataKeyMatchedBizData,
                            List<ColumnTag> columnTagList, String url) {
        if (!StringUtils.hasLength(url)) {
            return "";
        }
        List<UiBotLayout> uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return "";
        }
        String schema = pcUiBotModel.searchBizDataSchema();

        return getUrlByBizDataAndColumnTag(schema, url, dataKeyMatchedBizData, columnTagList);
    }

    private String getUrlByBizDataAndColumnTag(String schema, String url,
                                               Map<String, Object> bizData, List<ColumnTag> columnTagList) {
        //移动展示在线图纸tag
        List<ColumnTag> groupOnlineDrawingTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(schema) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_GRAPH_ONLINE_DRAWING.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                .collect(Collectors.toList());
        for (ColumnTag columnTag : groupOnlineDrawingTagList) {
            Map<String, Object> graphInfo = null;
            Object bizDataValue = bizData.get(columnTag.getSchema());
            if (bizDataValue instanceof List) {
                List<Map<String, Object>> listBizDataValue = (List<Map<String, Object>>) bizDataValue;
                if (!listBizDataValue.isEmpty()) {
                    graphInfo = listBizDataValue.get(0);
                }
            } else if (bizDataValue instanceof Map) {
                graphInfo = (Map<String, Object>) bizDataValue;
            }
            if (null == graphInfo) {
                continue;
            }
            String onlineDrawingFormat = String.valueOf(graphInfo.get("online_drawing_format"));
            String cadUrl = String.valueOf(graphInfo.get("cad_url"));
            String cadUrl3d = String.valueOf(graphInfo.get("cad_url_3d"));
            /**
             * 会有两种URL的配置：
             * ${athena_host}/graph-viewer?online_drawing_format=${cad_info.graph_info.online_drawing_format}&cad_url=${cad_info.graph_info.cad_url}
             * ${athena_host}/graph-viewer?online_drawing_format=${cad_info.graph_info.online_drawing_format}&cad_url=${cad_info.graph_info.cad_url_3d}
             */
            url = url.contains("${athena_host}") ? url.replace("${athena_host}", AppContext.getApiUrlSetting().getMuiUrl()) : url;
            url = url.contains("${cad_info.graph_info.online_drawing_format}") ? url.replace("${cad_info.graph_info.online_drawing_format}", onlineDrawingFormat) : url;
            url = url.contains("${cad_info.graph_info.cad_url}") ? url.replace("${cad_info.graph_info.cad_url}", cadUrl) : url;
            url = url.contains("${cad_info.graph_info.cad_url_3d}") ? url.replace("${cad_info.graph_info.cad_url_3d}", cadUrl3d) : url;
        }
        return url;
    }

    private List<ContainerContent> buildContentList(UiBotModel pcUiBotModel,
                                                    Map<String, Object> dataKeyMatchedBizData, List<ColumnTag> columnTagList, String locale) {
        List<UiBotLayout> uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }
        UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();
        String schema = pcUiBotModel.searchBizDataSchema();

        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        // 分解出明细数据行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition
                .decomposeTableColumnDefinitions(tableColumnDefinitionList);
        return getItemListByBizDataAndColumnTag(schema, tableColumns, dataKeyMatchedBizData, columnTagList, pcUiBotModel, locale);
    }

    private List<ContainerContent> getItemListByBizDataAndColumnTag(String path,
                                                                    List<UiBotTableColumn> tableColumns, Map<String, Object> bizData,
                                                                    List<ColumnTag> columnTagList, UiBotModel pcUiBotModel, String locale) {
        List<ContainerContent> containerContents = new ArrayList<>();
        Map<Integer, List<ColumnTag>> groupNos = new HashMap<>();
        // 分组字段tag
        List<ColumnTag> groupTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                .collect(Collectors.toList());
        for (ColumnTag columnTag : groupTagList) {
            List<ColumnTag> columnTags = groupNos.get(columnTag.getGroupNo());
            if (columnTags != null && columnTags.size() > 0) {
                columnTags.add(columnTag);
            } else {
                columnTags = new ArrayList<>();
                columnTags.add(columnTag);
                groupNos.put(columnTag.getGroupNo(), columnTags);
            }
        }
        //移动展示在线图纸tag
        List<ColumnTag> groupOnlineDrawingTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_GRAPH_ONLINE_DRAWING.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                .collect(Collectors.toList());

        for (Integer groupNo : groupNos.keySet()) {
            ContainerContent containerContent = new ContainerContent();
            List<ColumnTag> sameGroupNoColumnTags = groupNos.get(groupNo);
            if (sameGroupNoColumnTags.size() == 1) {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.EXCLUSIVE_ONE_LINE.getValue());
            } else {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.SHARE_ONE_LINE_AND_OVERFLOW_WITH_NEW_LINE.getValue());
            }
            containerContent.setGroupList(buildGroupList(tableColumns, sameGroupNoColumnTags, bizData, pcUiBotModel, locale));
            containerContents.add(containerContent);
        }
        return containerContents;
    }

    private List<UiBotModel> buildGroupList(List<UiBotTableColumn> tableColumns, List<ColumnTag> columnTags, Map<String, Object> bizData, UiBotModel pcUiBotModel, String locale) {
        // FIXME Field的AlignementType容易遗漏设置
        List<UiBotModel> uiBotModels = new ArrayList<>(columnTags.size());
        List<String> attSchema = new ArrayList<>();
        //上传附件
        Boolean isUpload = false;
        Integer hasAttach = 0;
        for (ColumnTag columnTag : columnTags) {
            List<UiBotLayout> layoutList = new ArrayList<>();
            UiBotLayout layout = new UiBotLayout();
            UiBotModel uiBotModel = new UiBotModel(layoutList);
            Field field = null;
            Attachment attachment = null;
            for (UiBotTableColumn uiBotTableColumn : tableColumns) {
                if (!uiBotTableColumn.getSchema().equals(columnTag.getSchema())) {
                    continue;
                }
                // FIXME 需要封装PC字段=》移动组件的翻译器，统一处理
                String dataType = Optional.ofNullable(uiBotTableColumn.getDataType()).orElse("");
                String type = Optional.ofNullable(uiBotTableColumn.getType()).orElse("");
                if (type.toUpperCase().contains("UPLOAD")) {
                    attSchema.add(columnTag.getSchema());
                    isUpload = true;
                    hasAttach++;
                    attachment = Attachment.create(Attachment.class, locale, uiBotTableColumn, bizData);
                    attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                } else {
                    isUpload = false;
                    field = Field.create(uiBotTableColumn, bizData, FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_CENTER);
                    break;
                }
                break;
            }
            if (isUpload) {
                //当附件为只读状态且无默认数据时，不显示附件组件
                if (attachment != null && attachment.getType() != null && Objects.equals(attachment.getType(), AttachmentTypeEnum.READ_ONLY.getValue())
                        && (attachment.getFileList() == null || attachment.getFileList().size() == 0)) {

                } else {
                    uiBotModel.addPageData(columnTag.getSchema(), attachment);
                }
            } else {
                if (field == null) {
                    if (StringUtils.hasLength(LocaleUtil.getMobileTextByDatabaseKey(locale, columnTag.getLabel()))) {
                        field = Field.create(
                                UiBotTableColumn.create(
                                        LocaleUtil.getMobileTextByDatabaseKey(locale, columnTag.getLabel()), columnTag.getSchema()),
                                bizData, FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_CENTER);
                        uiBotModel.addPageData(columnTag.getSchema(), field);
                    }
                } else {
                    uiBotModel.addPageData(columnTag.getSchema(), field);
                }
            }
            if (hasAttach > 0) {
                layout.setSchema(columnTag.getSchema());
                layout.setType(Attachment.COMPONENT_TYPE);
            } else {
                layout.setSchema(columnTag.getSchema());
                layout.setType(Field.COMPONENT_TYPE);
            }
            layoutList.add(layout);
            uiBotModels.add(uiBotModel);

        }
        return uiBotModels;
    }
}
