package com.digiwin.mobile.mobileuibot.core.component.layout.linear;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.BaseGroupMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;

import java.util.Map;
import java.util.Objects;


/**
 * 线性布局组件
 *
 * @author xujinc
 * @date 2025/01/07
 */
@Data
public class LinearLayout extends BaseGroupMobileComponent<BaseMobileComponent> {
    private static final long serialVersionUID = 6049656878967834095L;

    public static final String COMPONENT_TYPE = "LINEAR_LAYOUT";

    /**
     * 布局方向
     */
    private Integer layoutType = LayoutTypeEnum.VERTICAL.getValue();

    /**
     * 内边距
     */
    private Integer spacing;

    /**
     * 外边距
     */
    private Integer margin;

    /**
     * 比例
     */
    private String flex;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        //1为等比例标识，等比例flex不需要传值，前端没值会默认等比例
        if (Objects.equals(this.flex, "1")) {
            this.flex = null;
        }
        SpringContextHolder.getBean(UiBotDesignerRenderService.class).buildCmptDsl(cmptContext, executeContext, this.getContentGroup(), data, mobilePageRawData);
    }

    @Override
    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.LINEAR;
    }
}
