package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardConfigItem;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author zhangjj
 * @date 2021/6/23 0023 11:16
 */
@Data
public class Card extends BaseMobileComponent {
    private static final long serialVersionUID = 8681474612495896000L;
    public static final String COMPONENT_TYPE = "CARD_LIST_CARD";

    private String id;

    private Action action;
    private String name;
    private String startTime;
    private String endTime;
    private Boolean importance;
    /**
     * 0：一般，灰色；1：正常，蓝色；2：异常，红色
     */
    private Integer type;
    private List<Label> labelList;
    private ChildCard childCard;
    /**
     * 卡片进度
     * P.S. 当前在项目中控台类型的项目卡时使用。update on 20230119
     */
    private CardProgress progress;
    /**
     * 卡片底部提示文字（目前用于被分享卡片标识（来自xxxx的分享））
     */
    private String bottomTipText;

    /**
     * 筛选内容
     */
    private List<CardListFilter> filterContentList;
    /**
     * 是否为团队项目
     */
    private Boolean isTeamProject = false;


    // -----------begin-----------项目卡DigiwinAtmcProject属性---------------
//    private Long id;
//    private String name;
//    private String startTime;
//    private String endTime;
//    private Boolean importance;
    private String createTime;
    private Integer taskCount;
    // 0-不紧急，1-紧急
    private Integer emergency;
    private Integer emergencyProjectCount;
    private Integer subProjectCount;
    private Integer subProjectFinishedCount;
    private Boolean changed;
    private Boolean isOwner;
    private String ownerUserId;
    private Long readCount;
    private String tmTaskId;
    private Boolean exception;
    private Boolean overdue;
    private String modifyDate;
    private Boolean hasDataChanged;
    private List<DigiwinAtmcTask> tasks;
    // 项目类型名称
    private String projectName;
    private String personInCharge;
    private String personInChargeName;
    // 是否为被分享（web准确说是“钉选”功能，是项目卡“添加至他人athena”这个功能）
    private Boolean pinning;
    // 应用名称
    private String appCode;
    // 项目卡使用的引擎类型。示例：TaskEngine（表示任务引擎）
    private String engineType;
    // 数据来源：PTM表示来源于PTM，其他表示ATMC
    private String dataFrom;
    /**
     * 配置信息
     */
    private List<DigiwinAtmcCardConfigItem> cardConfig;

    private Map<String, Object> businessMessage;
    // -----------end-----------项目卡DigiwinAtmcProject属性---------------


    public Card() {
    }

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void convert(DigiwinAtmcProject project) {
        if (project == null) {
            return;
        }
        this.id = project.getId() + "";
        this.name = project.getName();
        this.startTime = project.getStartTime();
        this.endTime = project.getEndTime();
        this.importance = project.getImportance();
        this.createTime = project.getCreateTime();
        this.taskCount = project.getTaskCount();
        this.emergency = project.getEmergency();
        this.emergencyProjectCount = project.getEmergencyProjectCount();
        this.subProjectCount = project.getSubProjectCount();
        this.subProjectFinishedCount = project.getSubProjectFinishedCount();
        this.changed = project.getChanged();
        this.isOwner = project.getIsOwner();
        this.ownerUserId = project.getOwnerUserId();
        this.readCount = project.getReadCount();
        this.tmTaskId = project.getTmTaskId();
        this.exception = project.getException();
        this.overdue = project.getOverdue();
        this.modifyDate = project.getModifyDate();
        this.hasDataChanged = project.getHasDataChanged();
        this.tasks = project.getTasks();
        this.projectName = project.getProjectName();
        this.personInCharge = project.getPersonInCharge();
        this.personInChargeName = project.getPersonInChargeName();
        this.pinning = project.getPinning();
        this.appCode = project.getAppCode();
        this.engineType = project.getEngineType();
        this.dataFrom = project.getDataFrom();
        this.cardConfig = project.getCardConfig();
        this.businessMessage = project.getBusinessMessage();
    }
}
