package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.service.impl.ProjectServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 卡片分类组件，包含分类名称和分类下的卡片列表数据
 *
 * @author zhangjj
 * @date 2021/6/23 0023 14:37
 */
@Data
public class CardCategory extends BaseMobileComponent {
    private static final long serialVersionUID = -4709320522075057722L;
    public static final String COMPONENT_TYPE = "CARD_LIST_CATEGORY";

    private List<Card> cardList;
    private String categoryName;

    public static List<CardCategory> getByProjects(List<DigiwinAtmcProject> teamProjects,
                                                   ProjectFilterService projectFilterService,
                                                   ProjectServiceImpl projectServiceImpl,
                                                   List<ProjectServiceImpl.ProjectAndDoingTask> filteredProjectAndDoingTaskList, String locale, String iamUserToken, String userId,
                                                   String tenantId) {

        List<CardCategory> cardCategoryList = new ArrayList<>();
        //逾期/异常卡片列表
        CardCategory abnormalCardCategory = new CardCategory();
        abnormalCardCategory.setCategoryName(LocaleUtil.getMobileTextByKey(locale, "逾期/异常"));
        List<Card> abnormalCardList = new ArrayList<>();
        abnormalCardCategory.setCardList(abnormalCardList);
        //正常卡片列表
        CardCategory normalCardCategory = new CardCategory();
        normalCardCategory.setCategoryName(LocaleUtil.getMobileTextByKey(locale, "正常"));
        List<Card> normalCardList = new ArrayList<>();
        normalCardCategory.setCardList(normalCardList);

        if (!filteredProjectAndDoingTaskList.isEmpty()) {
            for (ProjectServiceImpl.ProjectAndDoingTask projectAndDoingTask : filteredProjectAndDoingTaskList) {
                DigiwinAtmcProject project = projectAndDoingTask.getProject();
                DigiwinAtmcTask doingTask = projectAndDoingTask.getTask();

                if (projectFilterService.isCenterConsoleProject(project, tenantId)) {
                    projectServiceImpl.handleCenterConsoleProject(project, doingTask, normalCardList, abnormalCardList, iamUserToken, tenantId, locale, true);
                } else if (projectFilterService.isStandardProject(project, tenantId)) {
                    projectServiceImpl.handleStandardProject(project, normalCardList, abnormalCardList, iamUserToken, locale, tenantId, true);
                } else if (projectFilterService.isSystemCloudHouseKeeper(project, tenantId)) {
                    projectServiceImpl.handleSystemCloudKeeperProject(project, doingTask, normalCardList, abnormalCardList, iamUserToken, tenantId, locale, true);
                } else {
                    projectServiceImpl.handleCurrentlyNotSupportedProject(project, normalCardList, abnormalCardList, iamUserToken, locale, tenantId, true);
                }
            }
        }

        if (!abnormalCardList.isEmpty()) {
            cardCategoryList.add(abnormalCardCategory);
        }
        if (!normalCardList.isEmpty()) {
            cardCategoryList.add(normalCardCategory);
        }
        return cardCategoryList;
    }

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }
}
