package com.digiwin.mobile.mobileuibot.core.component.list.card;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPersonnelStructure;
import lombok.Data;

import java.util.List;

/**
 * <p>功能描述：卡片列表组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CardList
 * @Author: Zaregoto
 * @Date: 2022/1/27 16:45
 */
@Data
public class CardList extends BaseMobileComponent {
    private static final long serialVersionUID = 2303431011536227933L;
    public static final String COMPONENT_TYPE = "CARD_LIST";

    @Override
    public String returnComponentType() {
        return CardList.COMPONENT_TYPE;
    }

    private List<CardCategory> categoryList;
    /**
     * 团队项目页面改造，平铺categoryList下card数据
     */
    private List<Card> cardList;
    /**
     * 搜索的url
     */
    private String searchUrl;
    private List<String> searchIdList;
    private String queryParam;
    /**
     * 筛选
     */
    private List<CardListFilter> filterList;
    /**
     * 分组配置
     */
    private CardListGroupFilter groupFilter;
    /**
     * 团队项目中的团队成员树结构及相关信息
     */
    private DigiwinAtmcPersonnelStructure personnelStructure;

    public CardList() {
    }

    public CardList(List<CardCategory> categoryList) {
        this.categoryList = categoryList;
    }


}
